/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Predicate;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="error")
@XmlRootElement(name="doCatch")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CatchDefinition
extends OutputDefinition<CatchDefinition> {
    @XmlTransient
    private List<Class<? extends Throwable>> exceptionClasses;
    @XmlElement(name="exception")
    private List<String> exceptions = new ArrayList<String>();
    @XmlElement(name="onWhen")
    @AsPredicate
    private WhenDefinition onWhen;

    public CatchDefinition() {
    }

    public CatchDefinition(List<Class<? extends Throwable>> exceptionClasses) {
        this.exception(exceptionClasses);
    }

    public CatchDefinition(Class<? extends Throwable> exceptionType) {
        this.exception(exceptionType);
    }

    @Override
    public String toString() {
        return "DoCatch[ " + this.getExceptionClasses() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "doCatch";
    }

    @Override
    public String getLabel() {
        return "doCatch[ " + this.getExceptionClasses() + "]";
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    public List<Class<? extends Throwable>> getExceptionClasses() {
        return this.exceptionClasses;
    }

    public void setExceptionClasses(List<Class<? extends Throwable>> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public CatchDefinition exception(Class<? extends Throwable> exception) {
        return this.exception(List.of(exception));
    }

    public CatchDefinition exception(Class<? extends Throwable> exception1, Class<? extends Throwable> exception2) {
        return this.exception(List.of(exception1, exception2));
    }

    public CatchDefinition exception(Class<? extends Throwable> exception1, Class<? extends Throwable> exception2, Class<? extends Throwable> exception3) {
        return this.exception(List.of(exception1, exception2, exception3));
    }

    @SafeVarargs
    public final CatchDefinition exception(Class<? extends Throwable> ... exceptions) {
        return this.exception(List.of(exceptions));
    }

    public CatchDefinition exception(List<Class<? extends Throwable>> exceptions) {
        if (this.exceptionClasses == null) {
            this.exceptionClasses = new ArrayList<Class<? extends Throwable>>();
        }
        for (Class<? extends Throwable> c : exceptions) {
            this.exceptionClasses.add(c);
            this.exceptions.add(c.getName());
        }
        return this;
    }

    public CatchDefinition onWhen(@AsPredicate Predicate predicate) {
        this.setOnWhen(new WhenDefinition(predicate));
        return this;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public WhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(WhenDefinition onWhen) {
        this.onWhen = onWhen;
    }
}

