/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.14.0", label="dataformat,transformation", title="Barcode")
@XmlRootElement(name="barcode")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BarcodeDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(enums="AZTEC,CODABAR,CODE_39,CODE_93,CODE_128,DATA_MATRIX,EAN_8,EAN_13,ITF,MAXICODE,PDF_417,QR_CODE,RSS_14,RSS_EXPANDED,UPC_A,UPC_E,UPC_EAN_EXTENSION", defaultValue="QR_CODE")
    private String barcodeFormat;
    @XmlAttribute
    @Metadata(enums="JPG,GIF,PNG", defaultValue="PNG")
    private String imageType;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer", defaultValue="100")
    private String width;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer", defaultValue="100")
    private String height;

    public BarcodeDataFormat() {
        super("barcode");
    }

    protected BarcodeDataFormat(BarcodeDataFormat source) {
        super(source);
        this.barcodeFormat = source.barcodeFormat;
        this.imageType = source.imageType;
        this.width = source.width;
        this.height = source.height;
    }

    private BarcodeDataFormat(Builder builder) {
        this();
        this.barcodeFormat = builder.barcodeFormat;
        this.imageType = builder.imageType;
        this.width = builder.width;
        this.height = builder.height;
    }

    @Override
    public BarcodeDataFormat copyDefinition() {
        return new BarcodeDataFormat(this);
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public String getBarcodeFormat() {
        return this.barcodeFormat;
    }

    public void setBarcodeFormat(String barcodeFormat) {
        this.barcodeFormat = barcodeFormat;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<BarcodeDataFormat> {
        private String barcodeFormat;
        private String imageType;
        private String width;
        private String height;

        public Builder width(String width) {
            this.width = width;
            return this;
        }

        public Builder width(int width) {
            this.width = Integer.toString(width);
            return this;
        }

        public Builder height(String height) {
            this.height = height;
            return this;
        }

        public Builder height(int height) {
            this.height = Integer.toString(height);
            return this;
        }

        public Builder imageType(String imageType) {
            this.imageType = imageType;
            return this;
        }

        public Builder barcodeFormat(String barcodeFormat) {
            this.barcodeFormat = barcodeFormat;
            return this;
        }

        @Override
        public BarcodeDataFormat end() {
            return new BarcodeDataFormat(this);
        }
    }
}

