/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.3.0", label="dataformat,transformation,security", title="Crypto (Java Cryptographic Extension)")
@XmlRootElement(name="crypto")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CryptoDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String algorithm;
    @XmlAttribute
    @Metadata(javaType="java.security.Key")
    private String key;
    @XmlAttribute
    @Metadata(label="advanced")
    private String cryptoProvider;
    @XmlAttribute
    @Metadata(label="advanced", javaType="byte[]")
    private String initVector;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.security.spec.AlgorithmParameterSpec")
    private String algorithmParameterSpec;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer", defaultValue="4096")
    private String bufferSize;
    @XmlAttribute
    @Metadata(defaultValue="HmacSHA1")
    private String macAlgorithm = "HmacSHA1";
    @XmlAttribute
    @Metadata(defaultValue="true", javaType="java.lang.Boolean")
    private String shouldAppendHMAC;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="false", javaType="java.lang.Boolean")
    private String inline;

    public CryptoDataFormat() {
        super("crypto");
    }

    protected CryptoDataFormat(CryptoDataFormat source) {
        super(source);
        this.algorithm = source.algorithm;
        this.key = source.key;
        this.cryptoProvider = source.cryptoProvider;
        this.initVector = source.initVector;
        this.algorithmParameterSpec = source.algorithmParameterSpec;
        this.bufferSize = source.bufferSize;
        this.macAlgorithm = source.macAlgorithm;
        this.shouldAppendHMAC = source.shouldAppendHMAC;
        this.inline = source.inline;
    }

    private CryptoDataFormat(Builder builder) {
        this();
        this.algorithm = builder.algorithm;
        this.key = builder.key;
        this.cryptoProvider = builder.cryptoProvider;
        this.initVector = builder.initVector;
        this.algorithmParameterSpec = builder.algorithmParameterSpec;
        this.bufferSize = builder.bufferSize;
        this.macAlgorithm = builder.macAlgorithm;
        this.shouldAppendHMAC = builder.shouldAppendHMAC;
        this.inline = builder.inline;
    }

    @Override
    public CryptoDataFormat copyDefinition() {
        return new CryptoDataFormat(this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(String cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getInitVector() {
        return this.initVector;
    }

    public void setInitVector(String initVector) {
        this.initVector = initVector;
    }

    public String getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    public void setAlgorithmParameterSpec(String algorithmParameterSpec) {
        this.algorithmParameterSpec = algorithmParameterSpec;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public String getShouldAppendHMAC() {
        return this.shouldAppendHMAC;
    }

    public void setShouldAppendHMAC(String shouldAppendHMAC) {
        this.shouldAppendHMAC = shouldAppendHMAC;
    }

    public String getInline() {
        return this.inline;
    }

    public void setInline(String inline) {
        this.inline = inline;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<CryptoDataFormat> {
        private String algorithm;
        private String key;
        private String cryptoProvider;
        private String initVector;
        private String algorithmParameterSpec;
        private String bufferSize;
        private String macAlgorithm = "HmacSHA1";
        private String shouldAppendHMAC;
        private String inline;

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder cryptoProvider(String cryptoProvider) {
            this.cryptoProvider = cryptoProvider;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder initVector(String initVector) {
            this.initVector = initVector;
            return this;
        }

        public Builder algorithmParameterSpec(String algorithmParameterSpec) {
            this.algorithmParameterSpec = algorithmParameterSpec;
            return this;
        }

        public Builder bufferSize(String bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = Integer.toString(bufferSize);
            return this;
        }

        public Builder macAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
            return this;
        }

        public Builder shouldAppendHMAC(String shouldAppendHMAC) {
            this.shouldAppendHMAC = shouldAppendHMAC;
            return this;
        }

        public Builder shouldAppendHMAC(boolean shouldAppendHMAC) {
            this.shouldAppendHMAC = Boolean.toString(shouldAppendHMAC);
            return this;
        }

        public Builder inline(String inline) {
            this.inline = inline;
            return this;
        }

        public Builder inline(boolean inline) {
            this.inline = Boolean.toString(inline);
            return this;
        }

        @Override
        public CryptoDataFormat end() {
            return new CryptoDataFormat(this);
        }
    }
}

