/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="3.20.0", label="dataformat,transformation,finance", title="SWIFT MX")
@XmlRootElement(name="swiftMx")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SwiftMxDataFormat
extends DataFormatDefinition {
    @XmlTransient
    private Object writeConfigObject;
    @XmlTransient
    private Object readConfigObject;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String writeInJson;
    @XmlAttribute
    @Metadata(label="advanced", javaType="com.prowidesoftware.swift.model.MxId")
    private String readMessageId;
    @XmlAttribute
    @Metadata(label="advanced", javaType="com.prowidesoftware.swift.model.mx.MxReadConfiguration")
    private String readConfig;
    @XmlAttribute
    @Metadata(label="advanced", javaType="com.prowidesoftware.swift.model.mx.MxWriteConfiguration")
    private String writeConfig;

    public SwiftMxDataFormat() {
        super("swiftMx");
    }

    protected SwiftMxDataFormat(SwiftMxDataFormat source) {
        super(source);
        this.writeConfig = source.writeConfig;
        this.writeConfigObject = source.writeConfigObject;
        this.writeInJson = source.writeInJson;
        this.readMessageId = source.readMessageId;
        this.readConfig = source.readConfig;
        this.readConfigObject = source.readConfigObject;
    }

    public SwiftMxDataFormat(boolean writeInJson) {
        this();
        this.writeInJson = Boolean.toString(writeInJson);
    }

    public SwiftMxDataFormat(boolean writeInJson, String readMessageId, Object readConfigObject) {
        this(writeInJson);
        this.readMessageId = readMessageId;
        this.readConfigObject = readConfigObject;
    }

    public SwiftMxDataFormat(boolean writeInJson, String readMessageId, String readConfig) {
        this(writeInJson);
        this.readMessageId = readMessageId;
        this.readConfig = readConfig;
    }

    public SwiftMxDataFormat(Object writeConfigObject, String readMessageId, Object readConfigObject) {
        this();
        this.writeConfigObject = writeConfigObject;
        this.readMessageId = readMessageId;
        this.readConfigObject = readConfigObject;
    }

    public SwiftMxDataFormat(String writeConfig, String readMessageId, String readConfig) {
        this();
        this.writeConfig = writeConfig;
        this.readMessageId = readMessageId;
        this.readConfig = readConfig;
    }

    private SwiftMxDataFormat(Builder builder) {
        this();
        this.writeConfig = builder.writeConfig;
        this.writeConfigObject = builder.writeConfigObject;
        this.writeInJson = builder.writeInJson;
        this.readMessageId = builder.readMessageId;
        this.readConfig = builder.readConfig;
        this.readConfigObject = builder.readConfigObject;
    }

    @Override
    public SwiftMxDataFormat copyDefinition() {
        return new SwiftMxDataFormat(this);
    }

    public Object getWriteConfigObject() {
        return this.writeConfigObject;
    }

    public void setWriteConfigObject(Object writeConfigObject) {
        this.writeConfigObject = writeConfigObject;
    }

    public String getWriteInJson() {
        return this.writeInJson;
    }

    public void setWriteInJson(String writeInJson) {
        this.writeInJson = writeInJson;
    }

    public String getReadMessageId() {
        return this.readMessageId;
    }

    public void setReadMessageId(String readMessageId) {
        this.readMessageId = readMessageId;
    }

    public Object getReadConfigObject() {
        return this.readConfigObject;
    }

    public void setReadConfigObject(Object readConfigObject) {
        this.readConfigObject = readConfigObject;
    }

    public String getWriteConfig() {
        return this.writeConfig;
    }

    public void setWriteConfig(String writeConfig) {
        this.writeConfig = writeConfig;
    }

    public String getReadConfig() {
        return this.readConfig;
    }

    public void setReadConfig(String readConfig) {
        this.readConfig = readConfig;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<SwiftMxDataFormat> {
        private String writeConfig;
        private Object writeConfigObject;
        private String writeInJson;
        private String readMessageId;
        private String readConfig;
        private Object readConfigObject;

        public Builder writeConfigObject(Object writeConfigObject) {
            this.writeConfigObject = writeConfigObject;
            return this;
        }

        public Builder writeInJson(String writeInJson) {
            this.writeInJson = writeInJson;
            return this;
        }

        public Builder writeInJson(boolean writeInJson) {
            this.writeInJson = Boolean.toString(writeInJson);
            return this;
        }

        public Builder readMessageId(String readMessageId) {
            this.readMessageId = readMessageId;
            return this;
        }

        public Builder readConfigObject(Object readConfigObject) {
            this.readConfigObject = readConfigObject;
            return this;
        }

        public Builder writeConfigObject(String writeConfig) {
            this.writeConfig = writeConfig;
            return this;
        }

        public Builder readConfig(String readConfig) {
            this.readConfig = readConfig;
            return this;
        }

        @Override
        public SwiftMxDataFormat end() {
            return new SwiftMxDataFormat(this);
        }
    }
}

