/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.AdviceWithTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdviceWith {
    private static final Logger LOG = LoggerFactory.getLogger(AdviceWith.class);

    private AdviceWith() {
    }

    public static RouteDefinition adviceWith(CamelContext camelContext, Object routeId, final ThrowingConsumer<AdviceWithRouteBuilder, Exception> builder) throws Exception {
        RouteDefinition rd = AdviceWith.findRouteDefinition(camelContext, routeId);
        return AdviceWith.doAdviceWith(rd, camelContext, new AdviceWithRouteBuilder(){

            @Override
            public void configure() throws Exception {
                builder.accept((Object)this);
            }
        });
    }

    public static RouteDefinition adviceWith(CamelContext camelContext, Object routeId, final boolean logXml, final ThrowingConsumer<AdviceWithRouteBuilder, Exception> builder) throws Exception {
        RouteDefinition rd = AdviceWith.findRouteDefinition(camelContext, routeId);
        return AdviceWith.adviceWith(rd, camelContext, (RouteBuilder)new AdviceWithRouteBuilder(){

            @Override
            public void configure() throws Exception {
                this.setLogRouteAsXml(logXml);
                builder.accept((Object)this);
            }
        });
    }

    public static RouteDefinition adviceWith(Object routeId, CamelContext camelContext, RouteBuilder builder) throws Exception {
        RouteDefinition rd = AdviceWith.findRouteDefinition(camelContext, routeId);
        return AdviceWith.adviceWith(rd, camelContext, builder);
    }

    public static RouteDefinition adviceWith(RouteDefinition definition, CamelContext camelContext, RouteBuilder builder) throws Exception {
        ObjectHelper.notNull((Object)definition, (String)"RouteDefinition");
        ObjectHelper.notNull((Object)camelContext, (String)"CamelContext");
        ObjectHelper.notNull((Object)builder, (String)"RouteBuilder");
        if (definition.getInput() == null) {
            throw new IllegalArgumentException("RouteDefinition has no input");
        }
        return AdviceWith.doAdviceWith(definition, camelContext, builder);
    }

    private static RouteDefinition doAdviceWith(RouteDefinition definition, CamelContext camelContext, RouteBuilder builder) throws Exception {
        ObjectHelper.notNull((Object)builder, (String)"RouteBuilder");
        LOG.debug("AdviceWith route before: {}", (Object)definition);
        ExtendedCamelContext ecc = camelContext.getCamelContextExtension();
        Model model = (Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class);
        if (builder instanceof AdviceWithRouteBuilder) {
            AdviceWithRouteBuilder arb = (AdviceWithRouteBuilder)builder;
            arb.setOriginalRoute(definition);
        }
        RoutesDefinition routes = builder.configureRoutes(camelContext);
        boolean logRoutesAsXml = true;
        if (builder instanceof AdviceWithRouteBuilder) {
            AdviceWithRouteBuilder arb = (AdviceWithRouteBuilder)builder;
            logRoutesAsXml = arb.isLogRouteAsXml();
        }
        LOG.debug("AdviceWith routes: {}", (Object)routes);
        if (!builder.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("You can only advice from a RouteBuilder which has no existing routes. Remove all routes from the route builder.");
        }
        if (builder.getRouteCollection().getErrorHandlerFactory() != null && ecc.getErrorHandlerFactory() != builder.getRouteCollection().getErrorHandlerFactory()) {
            throw new IllegalArgumentException("You can not advice with error handlers. Remove the error handlers from the route builder.");
        }
        String beforeAsXml = null;
        if (logRoutesAsXml && LOG.isInfoEnabled()) {
            try {
                ModelToXMLDumper modelToXMLDumper = PluginHelper.getModelToXMLDumper((ExtendedCamelContext)ecc);
                beforeAsXml = modelToXMLDumper.dumpModelAsXml(camelContext, (NamedNode)definition);
            }
            catch (Exception modelToXMLDumper) {
                // empty catch block
            }
        }
        model.removeRouteDefinition(definition);
        if (builder instanceof AdviceWithRouteBuilder) {
            List<AdviceWithTask> tasks = ((AdviceWithRouteBuilder)builder).getAdviceWithTasks();
            for (AdviceWithTask task : tasks) {
                task.task();
            }
        }
        RouteDefinition merged = routes.route(definition);
        merged.markUnprepared();
        routes.prepareRoute(merged);
        model.getRouteDefinitions().add(0, merged);
        if (LOG.isInfoEnabled()) {
            LOG.info("AdviceWith route after: {}", (Object)merged);
        }
        if (beforeAsXml != null && logRoutesAsXml && LOG.isInfoEnabled()) {
            try {
                ModelToXMLDumper modelToXMLDumper = PluginHelper.getModelToXMLDumper((ExtendedCamelContext)ecc);
                String afterAsXml = modelToXMLDumper.dumpModelAsXml(camelContext, (NamedNode)merged);
                LOG.info("Adviced route before/after as XML:\n{}\n\n{}", (Object)beforeAsXml, (Object)afterAsXml);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (camelContext.isStarted()) {
            model.addRouteDefinition(merged);
        }
        return merged;
    }

    private static RouteDefinition findRouteDefinition(CamelContext camelContext, Object routeId) {
        RouteDefinition rd;
        ModelCamelContext mcc = (ModelCamelContext)camelContext;
        if (mcc.getRouteDefinitions().isEmpty()) {
            throw new IllegalArgumentException("Cannot advice route as there are no routes");
        }
        if (routeId instanceof RouteDefinition) {
            rd = (RouteDefinition)routeId;
        } else {
            String id = (String)mcc.getTypeConverter().convertTo(String.class, routeId);
            if (id != null) {
                Integer num;
                rd = mcc.getRouteDefinition(id);
                if (rd == null && (num = (Integer)mcc.getTypeConverter().tryConvertTo(Integer.class, routeId)) != null) {
                    rd = (RouteDefinition)mcc.getRouteDefinitions().get(num);
                }
                if (rd == null) {
                    throw new IllegalArgumentException("Cannot advice route as route with id: " + String.valueOf(routeId) + " does not exists");
                }
            } else {
                rd = (RouteDefinition)mcc.getRouteDefinitions().get(0);
            }
        }
        return rd;
    }
}

