/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="throttle")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"expression", "correlationExpression"})
public class ThrottleDefinition
extends ExpressionNode
implements ExecutorServiceAwareDefinition<ThrottleDefinition> {
    @XmlTransient
    private ExecutorService executorServiceBean;
    @XmlElement(name="correlationExpression")
    private ExpressionSubElementDefinition correlationExpression;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.ExecutorService")
    private String executorService;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String asyncDelayed;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="true", javaType="java.lang.Boolean")
    private String callerRunsWhenRejected;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String rejectExecution;

    public ThrottleDefinition() {
    }

    public ThrottleDefinition(Expression maximumConcurrentRequests) {
        super(maximumConcurrentRequests);
    }

    public ThrottleDefinition(Expression maximumConcurrentRequests, Expression correlationExpression) {
        this(ExpressionNodeHelper.toExpressionDefinition(maximumConcurrentRequests), correlationExpression);
    }

    private ThrottleDefinition(ExpressionDefinition maximumConcurrentRequests, Expression correlationExpression) {
        super(maximumConcurrentRequests);
        ExpressionSubElementDefinition cor = new ExpressionSubElementDefinition();
        cor.setExpressionType(ExpressionNodeHelper.toExpressionDefinition(correlationExpression));
        this.setCorrelationExpression(cor);
    }

    public String toString() {
        return "Throttle[" + String.valueOf(this.getExpression()) + "]";
    }

    public String getShortName() {
        return "throttle";
    }

    @Override
    public String getLabel() {
        return "throttle[" + String.valueOf(this.getExpression()) + "]";
    }

    public ThrottleDefinition maximumConcurrentRequests(long maximumConcurrentRequests) {
        this.setExpression(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.constantExpression((Object)maximumConcurrentRequests)));
        return this;
    }

    public ThrottleDefinition maximumConcurrentRequests(String maximumConcurrentRequests) {
        this.setExpression(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.simpleExpression((String)maximumConcurrentRequests)));
        return this;
    }

    public ThrottleDefinition correlationExpression(long correlationExpression) {
        return this.correlationExpression(ExpressionBuilder.constantExpression((Object)correlationExpression));
    }

    public ThrottleDefinition correlationExpression(Expression correlationExpression) {
        ExpressionSubElementDefinition cor = new ExpressionSubElementDefinition();
        cor.setExpressionType(ExpressionNodeHelper.toExpressionDefinition(correlationExpression));
        this.setCorrelationExpression(cor);
        return this;
    }

    public ThrottleDefinition callerRunsWhenRejected(boolean callerRunsWhenRejected) {
        return this.callerRunsWhenRejected(Boolean.toString(callerRunsWhenRejected));
    }

    public ThrottleDefinition callerRunsWhenRejected(String callerRunsWhenRejected) {
        this.setCallerRunsWhenRejected(callerRunsWhenRejected);
        return this;
    }

    public ThrottleDefinition asyncDelayed() {
        return this.asyncDelayed(true);
    }

    public ThrottleDefinition asyncDelayed(boolean asyncDelayed) {
        return this.asyncDelayed(Boolean.toString(asyncDelayed));
    }

    public ThrottleDefinition asyncDelayed(String asyncDelayed) {
        this.setAsyncDelayed(asyncDelayed);
        return this;
    }

    public ThrottleDefinition rejectExecution(boolean rejectExecution) {
        return this.rejectExecution(Boolean.toString(rejectExecution));
    }

    public ThrottleDefinition rejectExecution(String rejectExecution) {
        this.setRejectExecution(rejectExecution);
        return this;
    }

    @Override
    public ThrottleDefinition executorService(ExecutorService executorService) {
        this.executorServiceBean = executorService;
        return this;
    }

    @Override
    public ThrottleDefinition executorService(String executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public ExecutorService getExecutorServiceBean() {
        return this.executorServiceBean;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorService;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(String asyncDelayed) {
        this.asyncDelayed = asyncDelayed;
    }

    public String getCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(String callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    public String getRejectExecution() {
        return this.rejectExecution;
    }

    public void setRejectExecution(String rejectExecution) {
        this.rejectExecution = rejectExecution;
    }

    public void setCorrelationExpression(ExpressionSubElementDefinition correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    public ExpressionSubElementDefinition getCorrelationExpression() {
        return this.correlationExpression;
    }

    public String getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(String executorService) {
        this.executorService = executorService;
    }
}

