/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.model.cloud.CombinedServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.model.cloud.ServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;

@Metadata(label="routing,cloud,service-discovery")
@XmlRootElement(name="cachingServiceDiscovery")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Configurer(extended=true)
@Deprecated
public class CachingServiceCallServiceDiscoveryConfiguration
extends ServiceCallServiceDiscoveryConfiguration {
    @XmlAttribute
    @Metadata(defaultValue="60", javaType="java.lang.Integer")
    private String timeout = Integer.toString(60);
    @XmlAttribute
    @Metadata(javaType="java.util.concurrent.TimeUnit", defaultValue="SECONDS", enums="NANOSECONDS,MICROSECONDS,MILLISECONDS,SECONDS,MINUTES,HOURS,DAYS")
    private String units = TimeUnit.SECONDS.name();
    @XmlElements(value={@XmlElement(name="consulServiceDiscovery", type=ConsulServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="dnsServiceDiscovery", type=DnsServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="kubernetesServiceDiscovery", type=KubernetesServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="combinedServiceDiscovery", type=CombinedServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="staticServiceDiscovery", type=StaticServiceCallServiceDiscoveryConfiguration.class)})
    private ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration;

    public CachingServiceCallServiceDiscoveryConfiguration() {
        this(null);
    }

    public CachingServiceCallServiceDiscoveryConfiguration(ServiceCallDefinition parent) {
        super(parent, "caching-service-discovery");
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public ServiceCallServiceDiscoveryConfiguration getServiceDiscoveryConfiguration() {
        return this.serviceDiscoveryConfiguration;
    }

    public void setServiceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.serviceDiscoveryConfiguration = serviceDiscoveryConfiguration;
    }

    public CachingServiceCallServiceDiscoveryConfiguration timeout(int timeout) {
        return this.timeout(Integer.toString(timeout));
    }

    public CachingServiceCallServiceDiscoveryConfiguration timeout(String timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public CachingServiceCallServiceDiscoveryConfiguration units(TimeUnit units) {
        return this.units(units.name());
    }

    public CachingServiceCallServiceDiscoveryConfiguration units(String units) {
        this.setUnits(units);
        return this;
    }

    public CachingServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.setServiceDiscoveryConfiguration(serviceDiscoveryConfiguration);
        return this;
    }

    public CachingServiceCallServiceDiscoveryConfiguration cachingServiceDiscovery() {
        CachingServiceCallServiceDiscoveryConfiguration conf = new CachingServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return this.serviceDiscoveryConfiguration(conf);
    }

    public ConsulServiceCallServiceDiscoveryConfiguration consulServiceDiscovery() {
        ConsulServiceCallServiceDiscoveryConfiguration conf = new ConsulServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public DnsServiceCallServiceDiscoveryConfiguration dnsServiceDiscovery() {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public KubernetesServiceCallServiceDiscoveryConfiguration kubernetesServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public CombinedServiceCallServiceDiscoveryConfiguration combinedServiceDiscovery() {
        CombinedServiceCallServiceDiscoveryConfiguration conf = new CombinedServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public StaticServiceCallServiceDiscoveryConfiguration staticServiceDiscovery() {
        StaticServiceCallServiceDiscoveryConfiguration conf = new StaticServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    @Override
    protected void postProcessFactoryParameters(CamelContext camelContext, Map<String, Object> parameters) throws Exception {
        if (this.serviceDiscoveryConfiguration != null) {
            parameters.put("serviceDiscovery", this.serviceDiscoveryConfiguration.newInstance(camelContext));
        }
    }
}

