/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.10.0", label="dataformat,transformation,csv", title="BeanIO")
@XmlRootElement(name="beanio")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BeanioDataFormat
extends DataFormatDefinition {
    @XmlAttribute(required=true)
    private String mapping;
    @XmlAttribute(required=true)
    private String streamName;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreUnidentifiedRecords;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreUnexpectedRecords;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreInvalidRecords;
    @XmlAttribute
    @Metadata(label="advanced")
    private String encoding;
    @XmlAttribute
    @Metadata(label="advanced")
    private String beanReaderErrorHandlerType;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String unmarshalSingleObject;

    public BeanioDataFormat() {
        super("beanio");
    }

    private BeanioDataFormat(Builder builder) {
        this();
        this.mapping = builder.mapping;
        this.streamName = builder.streamName;
        this.ignoreUnidentifiedRecords = builder.ignoreUnidentifiedRecords;
        this.ignoreUnexpectedRecords = builder.ignoreUnexpectedRecords;
        this.ignoreInvalidRecords = builder.ignoreInvalidRecords;
        this.encoding = builder.encoding;
        this.beanReaderErrorHandlerType = builder.beanReaderErrorHandlerType;
        this.unmarshalSingleObject = builder.unmarshalSingleObject;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getIgnoreUnidentifiedRecords() {
        return this.ignoreUnidentifiedRecords;
    }

    public void setIgnoreUnidentifiedRecords(String ignoreUnidentifiedRecords) {
        this.ignoreUnidentifiedRecords = ignoreUnidentifiedRecords;
    }

    public String getIgnoreUnexpectedRecords() {
        return this.ignoreUnexpectedRecords;
    }

    public void setIgnoreUnexpectedRecords(String ignoreUnexpectedRecords) {
        this.ignoreUnexpectedRecords = ignoreUnexpectedRecords;
    }

    public String getIgnoreInvalidRecords() {
        return this.ignoreInvalidRecords;
    }

    public void setIgnoreInvalidRecords(String ignoreInvalidRecords) {
        this.ignoreInvalidRecords = ignoreInvalidRecords;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getBeanReaderErrorHandlerType() {
        return this.beanReaderErrorHandlerType;
    }

    public void setBeanReaderErrorHandlerType(String beanReaderErrorHandlerType) {
        this.beanReaderErrorHandlerType = beanReaderErrorHandlerType;
    }

    public String getUnmarshalSingleObject() {
        return this.unmarshalSingleObject;
    }

    public void setUnmarshalSingleObject(String unmarshalSingleObject) {
        this.unmarshalSingleObject = unmarshalSingleObject;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<BeanioDataFormat> {
        private String mapping;
        private String streamName;
        private String ignoreUnidentifiedRecords;
        private String ignoreUnexpectedRecords;
        private String ignoreInvalidRecords;
        private String encoding;
        private String beanReaderErrorHandlerType;
        private String unmarshalSingleObject;

        public Builder mapping(String mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public Builder ignoreUnidentifiedRecords(String ignoreUnidentifiedRecords) {
            this.ignoreUnidentifiedRecords = ignoreUnidentifiedRecords;
            return this;
        }

        public Builder ignoreUnidentifiedRecords(boolean ignoreUnidentifiedRecords) {
            this.ignoreUnidentifiedRecords = ignoreUnidentifiedRecords ? "true" : "false";
            return this;
        }

        public Builder ignoreUnexpectedRecords(String ignoreUnexpectedRecords) {
            this.ignoreUnexpectedRecords = ignoreUnexpectedRecords;
            return this;
        }

        public Builder ignoreUnexpectedRecords(boolean ignoreUnexpectedRecords) {
            this.ignoreUnexpectedRecords = ignoreUnexpectedRecords ? "true" : "false";
            return this;
        }

        public Builder ignoreInvalidRecords(String ignoreInvalidRecords) {
            this.ignoreInvalidRecords = ignoreInvalidRecords;
            return this;
        }

        public Builder ignoreInvalidRecords(boolean ignoreInvalidRecords) {
            this.ignoreInvalidRecords = ignoreInvalidRecords ? "true" : "false";
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder beanReaderErrorHandlerType(String beanReaderErrorHandlerType) {
            this.beanReaderErrorHandlerType = beanReaderErrorHandlerType;
            return this;
        }

        public Builder unmarshalSingleObject(String unmarshalSingleObject) {
            this.unmarshalSingleObject = unmarshalSingleObject;
            return this;
        }

        public Builder unmarshalSingleObject(boolean unmarshalSingleObject) {
            this.unmarshalSingleObject = unmarshalSingleObject ? "true" : "false";
            return this;
        }

        @Override
        public BeanioDataFormat end() {
            return new BeanioDataFormat(this);
        }
    }
}

