/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.app.BeanPropertiesAdapter;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class BeanFactoryDefinition<T extends BeanFactoryDefinition<T, P>, P> {
    @XmlTransient
    private P parent;
    @XmlTransient
    private Class<?> beanClass;
    @XmlTransient
    private RouteTemplateContext.BeanSupplier<Object> beanSupplier;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=true)
    private String type;
    @XmlAttribute
    @Metadata(label="advanced")
    private String scriptLanguage;
    @XmlTransient
    private List<PropertyDefinition> propertyDefinitions;
    @XmlElement(name="properties")
    @XmlJavaTypeAdapter(value=BeanPropertiesAdapter.class)
    private Map<String, Object> properties;
    @XmlElement(name="script")
    @Metadata(label="advanced")
    private String script;

    void setParent(P parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanClass = beanType;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public List<PropertyDefinition> getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    public void setPropertyDefinitions(List<PropertyDefinition> propertyDefinitions) {
        this.propertyDefinitions = propertyDefinitions;
    }

    public void addProperty(PropertyDefinition property) {
        if (this.propertyDefinitions == null) {
            this.propertyDefinitions = new LinkedList<PropertyDefinition>();
        }
        this.propertyDefinitions.add(property);
    }

    public RouteTemplateContext.BeanSupplier<Object> getBeanSupplier() {
        return this.beanSupplier;
    }

    public void setBeanSupplier(RouteTemplateContext.BeanSupplier<Object> beanSupplier) {
        this.beanSupplier = beanSupplier;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public T type(String prefix, Class<?> type) {
        if (((String)prefix).startsWith("#type") || ((String)prefix).startsWith("#class")) {
            if (!((String)prefix).endsWith(":")) {
                prefix = (String)prefix + ":";
            }
            this.setType((String)prefix + type.getName());
        }
        this.setBeanType(type);
        return (T)this;
    }

    public T type(String type) {
        if (!((String)type).startsWith("#")) {
            type = "#class:" + (String)type;
        }
        this.setType((String)type);
        return (T)this;
    }

    public T typeClass(Class<?> type) {
        this.setType("#class:" + type.getName());
        return (T)this;
    }

    public T typeClass(String type) {
        this.setType("#class:" + type);
        return (T)this;
    }

    public T beanType(Class<?> type) {
        this.setBeanType(type);
        return (T)this;
    }

    public P bean(Class<?> type) {
        return this.bean(type, null);
    }

    public P bean(Class<?> type, String method) {
        this.setScriptLanguage("bean");
        this.setBeanType(type);
        if (method != null) {
            this.setScript(type.getName() + "?method=" + method);
        } else {
            this.setScript(type.getName());
        }
        return this.parent;
    }

    public P groovy(String script) {
        this.setScriptLanguage("groovy");
        this.setScript(script);
        return this.parent;
    }

    public P joor(String script) {
        this.setScriptLanguage("joor");
        this.setScript(script);
        return this.parent;
    }

    public P java(String script) {
        return this.joor(script);
    }

    public P language(String language, String script) {
        this.setScriptLanguage(language);
        this.setScript(script);
        return this.parent;
    }

    public P mvel(String script) {
        this.setScriptLanguage("mvel");
        this.setScript(script);
        return this.parent;
    }

    public P ognl(String script) {
        this.setScriptLanguage("ognl");
        this.setScript(script);
        return this.parent;
    }

    public T property(String key, String value) {
        if (this.propertyDefinitions == null) {
            this.propertyDefinitions = new LinkedList<PropertyDefinition>();
        }
        this.propertyDefinitions.add(new PropertyDefinition(key, value));
        return (T)this;
    }

    public T properties(Map<String, Object> properties) {
        this.properties = properties;
        return (T)this;
    }

    public P end() {
        return this.parent;
    }
}

