/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.function.Suppliers;

public final class BeanModelHelper {
    private BeanModelHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object newInstance(BeanFactoryDefinition def, CamelContext context) throws Exception {
        boolean setProps;
        Object target;
        Object type = def.getType();
        if (!((String)type).startsWith("#")) {
            type = "#class:" + (String)type;
        }
        if (def.getScriptLanguage() != null && def.getScript() != null) {
            Language lan = context.resolveLanguage(def.getScriptLanguage());
            ScriptingLanguage slan = lan instanceof ScriptingLanguage ? (ScriptingLanguage)lan : null;
            String fqn = def.getType();
            if (fqn.startsWith("#class:")) {
                fqn = fqn.substring(7);
            }
            Class clazz = context.getClassResolver().resolveMandatoryClass(fqn);
            if (slan != null) {
                HashMap<String, CamelContext> bindings = new HashMap<String, CamelContext>();
                bindings.put("context", context);
                target = slan.evaluate(def.getScript(), bindings, clazz);
            } else {
                ExchangeFactory ef = context.getCamelContextExtension().getExchangeFactory();
                Exchange dummy = ef.create(false);
                try {
                    String text = ScriptHelper.resolveOptionalExternalScript((CamelContext)context, (Exchange)dummy, (String)def.getScript());
                    Expression exp = lan.createExpression(text);
                    target = exp.evaluate(dummy, clazz);
                }
                finally {
                    ef.release(dummy);
                }
            }
            if (target == null) {
                throw new NoSuchBeanException(def.getName(), "Creating bean using script returned null");
            }
        } else if (def.getBuilderClass() != null) {
            Class clazz = context.getClassResolver().resolveMandatoryClass(def.getBuilderClass());
            Object builder = context.getInjector().newInstance(clazz);
            String bm = def.getBuilderMethod() != null ? def.getBuilderMethod() : "build";
            target = PropertyBindingSupport.build().withCamelContext(context).withTarget(builder).withRemoveParameters(true).withProperties(def.getProperties()).build(Object.class, bm);
        } else {
            if (def.getFactoryBean() != null && def.getFactoryMethod() != null) {
                type = (String)type + "#" + def.getFactoryBean() + ":" + def.getFactoryMethod();
            } else if (def.getFactoryMethod() != null) {
                type = (String)type + "#" + def.getFactoryMethod();
            }
            StringJoiner ctr = new StringJoiner(", ");
            if (def.getConstructors() != null && !def.getConstructors().isEmpty()) {
                TreeMap<Integer, Object> sorted = new TreeMap<Integer, Object>(def.getConstructors());
                for (Object val : sorted.values()) {
                    Object text = val.toString();
                    if (!StringHelper.isQuoted((String)text)) {
                        text = "\"" + (String)text + "\"";
                    }
                    ctr.add((CharSequence)text);
                }
                type = (String)type + "(" + String.valueOf(ctr) + ")";
            }
            target = PropertyBindingSupport.resolveBean((CamelContext)context, (Object)type);
        }
        boolean bl = setProps = !((String)type).startsWith("#type");
        if (setProps && def.getProperties() != null && !def.getProperties().isEmpty()) {
            PropertyBindingSupport.setPropertiesOnTarget((CamelContext)context, (Object)target, def.getProperties());
        }
        return target;
    }

    public static void bind(BeanFactoryDefinition<?> def, RouteTemplateContext routeTemplateContext) throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (def.getProperties() != null) {
            props.putAll(def.getProperties());
        }
        if (def.getBeanSupplier() != null) {
            if (props.isEmpty()) {
                if (def.getBeanClass() != null) {
                    routeTemplateContext.bind(def.getName(), def.getBeanClass(), def.getBeanSupplier());
                } else {
                    routeTemplateContext.bind(def.getName(), def.getBeanSupplier());
                }
            }
        } else if (def.getScript() != null && def.getScriptLanguage() != null) {
            ScriptingLanguage slan;
            Class clazz;
            CamelContext camelContext = routeTemplateContext.getCamelContext();
            Language lan = camelContext.resolveLanguage(def.getScriptLanguage());
            if (def.getBeanClass() != null) {
                clazz = def.getBeanClass();
            } else if (def.getType() != null) {
                String fqn = def.getType();
                if (fqn.contains(":")) {
                    fqn = StringHelper.after((String)fqn, (String)":");
                }
                clazz = camelContext.getClassResolver().resolveMandatoryClass(fqn);
            } else {
                clazz = Object.class;
            }
            String script = def.getScript();
            ScriptingLanguage scriptingLanguage = slan = lan instanceof ScriptingLanguage ? (ScriptingLanguage)lan : null;
            if (slan != null) {
                routeTemplateContext.bind(def.getName(), clazz, Suppliers.memorize(() -> {
                    Object local;
                    HashMap<String, RouteTemplateContext> bindings = new HashMap<String, RouteTemplateContext>();
                    bindings.put("rtc", routeTemplateContext);
                    try {
                        local = slan.evaluate(script, bindings, Object.class);
                        if (!props.isEmpty()) {
                            PropertyBindingSupport.setPropertiesOnTarget((CamelContext)camelContext, (Object)local, (Map)props);
                        }
                        if (def.getInitMethod() != null) {
                            ObjectHelper.invokeMethodSafe((String)def.getInitMethod(), (Object)local, (Object[])new Object[0]);
                        }
                        if (def.getDestroyMethod() != null) {
                            routeTemplateContext.registerDestroyMethod(def.getName(), def.getDestroyMethod());
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot create bean: " + def.getType(), e);
                    }
                    return local;
                }));
            } else {
                routeTemplateContext.bind(def.getName(), clazz, Suppliers.memorize(() -> {
                    ExchangeFactory ef = camelContext.getCamelContextExtension().getExchangeFactory();
                    Exchange dummy = ef.create(false);
                    try {
                        String text = ScriptHelper.resolveOptionalExternalScript((CamelContext)camelContext, (Exchange)dummy, (String)script);
                        if (text != null) {
                            Expression exp = lan.createExpression(text);
                            Object local = exp.evaluate(dummy, clazz);
                            if (!props.isEmpty()) {
                                PropertyBindingSupport.setPropertiesOnTarget((CamelContext)camelContext, (Object)local, (Map)props);
                            }
                            if (def.getInitMethod() != null) {
                                try {
                                    ObjectHelper.invokeMethodSafe((String)def.getInitMethod(), (Object)local, (Object[])new Object[0]);
                                }
                                catch (Exception e) {
                                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                                }
                            }
                            if (def.getDestroyMethod() != null) {
                                routeTemplateContext.registerDestroyMethod(def.getName(), def.getDestroyMethod());
                            }
                            Object object = local;
                            return object;
                        }
                        Object var10_12 = null;
                        return var10_12;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot create bean: " + def.getType(), e);
                    }
                    finally {
                        ef.release(dummy);
                    }
                }));
            }
        } else if (def.getBeanClass() != null || def.getType() != null) {
            Object type = def.getType();
            if (type == null) {
                type = def.getBeanClass().getName();
            }
            if (!((String)type).startsWith("#")) {
                type = "#class:" + (String)type;
            }
            if (def.getFactoryBean() != null && def.getFactoryMethod() != null) {
                type = (String)type + "#" + def.getFactoryBean() + ":" + def.getFactoryMethod();
            } else if (def.getFactoryMethod() != null) {
                type = (String)type + "#" + def.getFactoryMethod();
            }
            StringJoiner ctr = new StringJoiner(", ");
            if (def.getConstructors() != null && !def.getConstructors().isEmpty()) {
                TreeMap<Integer, Object> sorted = new TreeMap<Integer, Object>(def.getConstructors());
                for (Object val : sorted.values()) {
                    Object text = val.toString();
                    if (!StringHelper.isQuoted((String)text)) {
                        text = "\"" + (String)text + "\"";
                    }
                    ctr.add((CharSequence)text);
                }
                type = (String)type + "(" + String.valueOf(ctr) + ")";
            }
            Object classType = type;
            CamelContext camelContext = routeTemplateContext.getCamelContext();
            routeTemplateContext.bind(def.getName(), Object.class, Suppliers.memorize(() -> BeanModelHelper.lambda$bind$2(camelContext, (String)classType, def, routeTemplateContext)));
        } else {
            throw new IllegalArgumentException("Route template local bean: " + def.getName() + " has invalid type syntax: " + def.getType() + ". To refer to a class then prefix the value with #class such as: #class:fullyQualifiedClassName");
        }
    }

    private static /* synthetic */ Object lambda$bind$2(CamelContext camelContext, String classType, BeanFactoryDefinition def, RouteTemplateContext routeTemplateContext) {
        try {
            boolean setProps;
            Object local = PropertyBindingSupport.resolveBean((CamelContext)camelContext, (Object)classType);
            boolean bl = setProps = !classType.startsWith("#type");
            if (setProps && def.getProperties() != null && !def.getProperties().isEmpty()) {
                PropertyBindingSupport.setPropertiesOnTarget((CamelContext)camelContext, (Object)local, def.getProperties());
            }
            if (def.getInitMethod() != null) {
                ObjectHelper.invokeMethodSafe((String)def.getInitMethod(), (Object)local, (Object[])new Object[0]);
            }
            if (def.getDestroyMethod() != null) {
                routeTemplateContext.registerDestroyMethod(def.getName(), def.getDestroyMethod());
            }
            return local;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create bean: " + def.getType(), e);
        }
    }
}

