/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.core.osgi.OsgiCamelContextHelper;
import org.apache.camel.core.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.core.osgi.OsgiServiceRegistry;
import org.apache.camel.core.osgi.OsgiTypeConverter;
import org.apache.camel.core.osgi.utils.BundleContextUtils;
import org.apache.camel.core.osgi.utils.BundleDelegatingClassLoader;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.LoadPropertiesException;
import org.osgi.framework.BundleContext;

public class OsgiDefaultCamelContext
extends DefaultCamelContext {
    private final BundleContext bundleContext;
    private final Registry registry;

    public OsgiDefaultCamelContext(BundleContext bundleContext) {
        this(bundleContext, new OsgiServiceRegistry(bundleContext));
    }

    public OsgiDefaultCamelContext(BundleContext bundleContext, Registry registry) {
        super(registry);
        this.bundleContext = bundleContext;
        this.registry = registry;
        OsgiCamelContextHelper.osgiUpdate(this, bundleContext);
        this.setApplicationContextClassLoader(new BundleDelegatingClassLoader(bundleContext.getBundle()));
    }

    public Map<String, Properties> findComponents() throws LoadPropertiesException, IOException {
        return BundleContextUtils.findComponents(this.bundleContext, (CamelContext)this);
    }

    public String getComponentDocumentation(String componentName) throws IOException {
        return BundleContextUtils.getComponentDocumentation(this.bundleContext, (CamelContext)this, componentName);
    }

    protected Registry createRegistry() {
        if (this.registry != null) {
            return OsgiCamelContextHelper.wrapRegistry((CamelContext)this, this.registry, this.bundleContext);
        }
        return OsgiCamelContextHelper.wrapRegistry((CamelContext)this, super.createRegistry(), this.bundleContext);
    }

    protected TypeConverter createTypeConverter() {
        BundleContext ctx = BundleContextUtils.getBundleContext(((Object)((Object)this)).getClass());
        if (ctx == null) {
            ctx = this.bundleContext;
        }
        FactoryFinder finder = new OsgiFactoryFinderResolver(this.bundleContext).resolveDefaultFactoryFinder(this.getClassResolver());
        return new OsgiTypeConverter(ctx, (CamelContext)this, this.getInjector(), finder);
    }
}

