/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.Exchange;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SwitchDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.ExpressionFactoryAware;
import org.apache.camel.support.DefaultExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchReifier
extends ProcessorReifier<SwitchDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(SwitchReifier.class);

    public SwitchReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (SwitchDefinition)SwitchDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        for (WhenDefinition whenClause : ((SwitchDefinition)this.definition).getWhenClauses()) {
            ExpressionFactory model;
            ExpressionFactoryAware aware;
            Predicate pre;
            ExpressionDefinition exp = whenClause.getExpression();
            if (exp.getExpressionType() != null) {
                exp = exp.getExpressionType();
            }
            if (!((pre = exp.getPredicate()) instanceof ExpressionFactoryAware) || (aware = (ExpressionFactoryAware)pre).getExpressionFactory() == null || !((model = aware.getExpressionFactory()) instanceof ExpressionDefinition)) continue;
            whenClause.setExpression((ExpressionDefinition)model);
        }
        DefaultExchange dummy = new DefaultExchange(this.camelContext);
        for (WhenDefinition whenClause : ((SwitchDefinition)this.definition).getWhenClauses()) {
            ExpressionDefinition exp = whenClause.getExpression();
            exp.initPredicate(this.camelContext);
            Predicate predicate = exp.getPredicate();
            predicate.initPredicate(this.camelContext);
            boolean matches = predicate.matches((Exchange)dummy);
            if (!matches) continue;
            LOG.debug("doSwitch selected: {}", (Object)whenClause.getLabel());
            return this.createOutputsProcessor(whenClause.getOutputs());
        }
        if (((SwitchDefinition)this.definition).getOtherwise() != null) {
            LOG.debug("doSwitch selected: otherwise");
            return this.createProcessor((ProcessorDefinition<?>)((SwitchDefinition)this.definition).getOtherwise());
        }
        LOG.debug("doSwitch no when or otherwise selected");
        return null;
    }
}

