/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.loadbalancer;

import java.util.ArrayList;
import org.apache.camel.Route;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.FailOverLoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.reifier.loadbalancer.LoadBalancerReifier;
import org.apache.camel.util.ObjectHelper;

public class FailoverLoadBalancerReifier
extends LoadBalancerReifier<FailoverLoadBalancerDefinition> {
    public FailoverLoadBalancerReifier(Route route, LoadBalancerDefinition definition) {
        super(route, (FailoverLoadBalancerDefinition)definition);
    }

    @Override
    public LoadBalancer createLoadBalancer() {
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!((FailoverLoadBalancerDefinition)this.definition).getExceptionTypes().isEmpty()) {
            classes.addAll(((FailoverLoadBalancerDefinition)this.definition).getExceptionTypes());
        } else if (!((FailoverLoadBalancerDefinition)this.definition).getExceptions().isEmpty()) {
            for (String name : ((FailoverLoadBalancerDefinition)this.definition).getExceptions()) {
                Class type = this.camelContext.getClassResolver().resolveClass(name);
                if (type == null) {
                    throw new IllegalArgumentException("Cannot find class: " + name + " in the classpath");
                }
                if (!ObjectHelper.isAssignableFrom(Throwable.class, (Class)type)) {
                    throw new IllegalArgumentException("Class is not an instance of Throwable: " + type);
                }
                classes.add(type);
            }
        }
        FailOverLoadBalancer answer = classes.isEmpty() ? new FailOverLoadBalancer() : new FailOverLoadBalancer(classes);
        Integer num = this.parseInt(((FailoverLoadBalancerDefinition)this.definition).getMaximumFailoverAttempts());
        if (num != null) {
            answer.setMaximumFailoverAttempts(num.intValue());
        }
        if (((FailoverLoadBalancerDefinition)this.definition).getRoundRobin() != null) {
            answer.setRoundRobin(this.parseBoolean(((FailoverLoadBalancerDefinition)this.definition).getRoundRobin(), false));
        }
        if (((FailoverLoadBalancerDefinition)this.definition).getSticky() != null) {
            answer.setSticky(this.parseBoolean(((FailoverLoadBalancerDefinition)this.definition).getSticky(), false));
        }
        return answer;
    }
}

