/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.Map;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.UniVocityAbstractDataFormat;
import org.apache.camel.model.dataformat.UniVocityHeader;
import org.apache.camel.reifier.dataformat.DataFormatReifier;

public class UniVocityAbstractDataFormatReifier<T extends UniVocityAbstractDataFormat>
extends DataFormatReifier<T> {
    public UniVocityAbstractDataFormatReifier(CamelContext camelContext, DataFormatDefinition definition) {
        super(camelContext, (UniVocityAbstractDataFormat)definition);
    }

    @Override
    protected void prepareDataFormatConfig(Map<String, Object> properties) {
        properties.put("nullValue", ((UniVocityAbstractDataFormat)this.definition).getNullValue());
        properties.put("skipEmptyLines", ((UniVocityAbstractDataFormat)this.definition).getSkipEmptyLines());
        properties.put("ignoreTrailingWhitespaces", ((UniVocityAbstractDataFormat)this.definition).getIgnoreTrailingWhitespaces());
        properties.put("ignoreLeadingWhitespaces", ((UniVocityAbstractDataFormat)this.definition).getIgnoreLeadingWhitespaces());
        properties.put("headersDisabled", ((UniVocityAbstractDataFormat)this.definition).getHeadersDisabled());
        properties.put("headers", this.getValidHeaderNames());
        properties.put("headerExtractionEnabled", ((UniVocityAbstractDataFormat)this.definition).getHeaderExtractionEnabled());
        properties.put("numberOfRecordsToRead", ((UniVocityAbstractDataFormat)this.definition).getNumberOfRecordsToRead());
        properties.put("emptyValue", ((UniVocityAbstractDataFormat)this.definition).getEmptyValue());
        properties.put("lineSeparator", ((UniVocityAbstractDataFormat)this.definition).getLineSeparator());
        properties.put("normalizedLineSeparator", ((UniVocityAbstractDataFormat)this.definition).getNormalizedLineSeparator());
        properties.put("comment", ((UniVocityAbstractDataFormat)this.definition).getComment());
        properties.put("lazyLoad", ((UniVocityAbstractDataFormat)this.definition).getLazyLoad());
        properties.put("asMap", ((UniVocityAbstractDataFormat)this.definition).getAsMap());
    }

    private String getValidHeaderNames() {
        if (((UniVocityAbstractDataFormat)this.definition).getHeaders() == null) {
            return null;
        }
        StringJoiner sj = new StringJoiner(",");
        for (UniVocityHeader header : ((UniVocityAbstractDataFormat)this.definition).getHeaders()) {
            if (header.getName() == null || header.getName().isEmpty()) continue;
            sj.add(header.getName());
        }
        if (sj.length() > 0) {
            return sj.toString();
        }
        return null;
    }
}

