/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.YAMLDataFormat;
import org.apache.camel.model.dataformat.YAMLLibrary;
import org.apache.camel.reifier.dataformat.DataFormatReifier;

public class YAMLDataFormatReifier
extends DataFormatReifier<YAMLDataFormat> {
    public YAMLDataFormatReifier(CamelContext camelContext, DataFormatDefinition definition) {
        super(camelContext, (YAMLDataFormat)definition);
    }

    @Override
    protected void prepareDataFormatConfig(Map<String, Object> properties) {
        if (((YAMLDataFormat)this.definition).getLibrary() == YAMLLibrary.SnakeYAML) {
            this.configureSnakeDataFormat(properties);
        }
    }

    protected void configureSnakeDataFormat(Map<String, Object> properties) {
        properties.put("unmarshalType", this.or(((YAMLDataFormat)this.definition).getUnmarshalType(), ((YAMLDataFormat)this.definition).getUnmarshalTypeName()));
        properties.put("classLoader", ((YAMLDataFormat)this.definition).getClassLoader());
        properties.put("useApplicationContextClassLoader", ((YAMLDataFormat)this.definition).getUseApplicationContextClassLoader());
        properties.put("prettyFlow", ((YAMLDataFormat)this.definition).getPrettyFlow());
        properties.put("allowAnyType", ((YAMLDataFormat)this.definition).getAllowAnyType());
        properties.put("typeFilters", ((YAMLDataFormat)this.definition).getTypeFilter());
        properties.put("constructor", ((YAMLDataFormat)this.definition).getConstructor());
        properties.put("representer", ((YAMLDataFormat)this.definition).getRepresenter());
        properties.put("dumperOptions", ((YAMLDataFormat)this.definition).getDumperOptions());
        properties.put("resolver", ((YAMLDataFormat)this.definition).getResolver());
        properties.put("maxAliasesForCollections", ((YAMLDataFormat)this.definition).getMaxAliasesForCollections());
        properties.put("allowRecursiveKeys", ((YAMLDataFormat)this.definition).getAllowRecursiveKeys());
    }
}

