/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolicyReifier<T extends ProcessorDefinition<?>>
extends ProcessorReifier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPolicyReifier.class);

    public AbstractPolicyReifier(Route route, T definition) {
        super(route, definition);
    }

    public AbstractPolicyReifier(CamelContext camelContext, T definition) {
        super(camelContext, definition);
    }

    public Policy resolvePolicy(Policy policy, String ref, Class<? extends Policy> type) {
        Class tmClazz;
        Policy found;
        if (policy != null) {
            return policy;
        }
        if (ObjectHelper.isNotEmpty((String)ref)) {
            return this.mandatoryLookup(ref, Policy.class);
        }
        Policy answer = null;
        if (type != null && (found = (Policy)this.findSingleByType(type)) != null) {
            return found;
        }
        if (type == TransactedPolicy.class) {
            answer = (Policy)this.lookupByNameAndType("PROPAGATION_REQUIRED", TransactedPolicy.class);
        }
        if (answer == null && type == TransactedPolicy.class && (tmClazz = this.camelContext.getClassResolver().resolveClass("org.springframework.transaction.PlatformTransactionManager")) != null) {
            Object transactionManager = this.mandatoryFindSingleByType(tmClazz);
            LOG.debug("One instance of PlatformTransactionManager found in registry: {}", transactionManager);
            Class txClazz = this.camelContext.getClassResolver().resolveClass("org.apache.camel.spring.spi.SpringTransactionPolicy");
            if (txClazz != null) {
                Method method;
                LOG.debug("Creating a new temporary SpringTransactionPolicy using the PlatformTransactionManager: {}", transactionManager);
                TransactedPolicy txPolicy = (TransactedPolicy)org.apache.camel.support.ObjectHelper.newInstance((Class)txClazz, TransactedPolicy.class);
                try {
                    method = txClazz.getMethod("setTransactionManager", tmClazz);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeCamelException("Cannot get method setTransactionManager(PlatformTransactionManager) on class: " + txClazz);
                }
                org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)txPolicy, (Object[])new Object[]{transactionManager});
                return txPolicy;
            }
            throw new RuntimeCamelException("Cannot create a transacted policy as camel-spring.jar is not on the classpath!");
        }
        return answer;
    }
}

