/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.dataformat.ASN1DataFormat;
import org.apache.camel.model.dataformat.AvroDataFormat;
import org.apache.camel.model.dataformat.BarcodeDataFormat;
import org.apache.camel.model.dataformat.Base64DataFormat;
import org.apache.camel.model.dataformat.BeanioDataFormat;
import org.apache.camel.model.dataformat.BindyDataFormat;
import org.apache.camel.model.dataformat.CBORDataFormat;
import org.apache.camel.model.dataformat.ContentTypeHeaderAware;
import org.apache.camel.model.dataformat.CryptoDataFormat;
import org.apache.camel.model.dataformat.CsvDataFormat;
import org.apache.camel.model.dataformat.CustomDataFormat;
import org.apache.camel.model.dataformat.FhirDataformat;
import org.apache.camel.model.dataformat.FhirJsonDataFormat;
import org.apache.camel.model.dataformat.FhirXmlDataFormat;
import org.apache.camel.model.dataformat.FlatpackDataFormat;
import org.apache.camel.model.dataformat.GrokDataFormat;
import org.apache.camel.model.dataformat.GzipDeflaterDataFormat;
import org.apache.camel.model.dataformat.HL7DataFormat;
import org.apache.camel.model.dataformat.IcalDataFormat;
import org.apache.camel.model.dataformat.JacksonXMLDataFormat;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.JsonApiDataFormat;
import org.apache.camel.model.dataformat.JsonDataFormat;
import org.apache.camel.model.dataformat.LZFDataFormat;
import org.apache.camel.model.dataformat.MimeMultipartDataFormat;
import org.apache.camel.model.dataformat.PGPDataFormat;
import org.apache.camel.model.dataformat.ParquetAvroDataFormat;
import org.apache.camel.model.dataformat.ProtobufDataFormat;
import org.apache.camel.model.dataformat.RssDataFormat;
import org.apache.camel.model.dataformat.SoapDataFormat;
import org.apache.camel.model.dataformat.SwiftMtDataFormat;
import org.apache.camel.model.dataformat.SwiftMxDataFormat;
import org.apache.camel.model.dataformat.SyslogDataFormat;
import org.apache.camel.model.dataformat.TarFileDataFormat;
import org.apache.camel.model.dataformat.ThriftDataFormat;
import org.apache.camel.model.dataformat.TidyMarkupDataFormat;
import org.apache.camel.model.dataformat.UniVocityCsvDataFormat;
import org.apache.camel.model.dataformat.UniVocityFixedDataFormat;
import org.apache.camel.model.dataformat.UniVocityTsvDataFormat;
import org.apache.camel.model.dataformat.XMLSecurityDataFormat;
import org.apache.camel.model.dataformat.YAMLDataFormat;
import org.apache.camel.model.dataformat.ZipDeflaterDataFormat;
import org.apache.camel.model.dataformat.ZipFileDataFormat;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.dataformat.ASN1DataFormatReifier;
import org.apache.camel.reifier.dataformat.AvroDataFormatReifier;
import org.apache.camel.reifier.dataformat.BarcodeDataFormatReifier;
import org.apache.camel.reifier.dataformat.Base64DataFormatReifier;
import org.apache.camel.reifier.dataformat.BeanioDataFormatReifier;
import org.apache.camel.reifier.dataformat.BindyDataFormatReifier;
import org.apache.camel.reifier.dataformat.CBORDataFormatReifier;
import org.apache.camel.reifier.dataformat.CryptoDataFormatReifier;
import org.apache.camel.reifier.dataformat.CsvDataFormatReifier;
import org.apache.camel.reifier.dataformat.CustomDataFormatReifier;
import org.apache.camel.reifier.dataformat.FhirDataFormatReifier;
import org.apache.camel.reifier.dataformat.FhirJsonDataFormatReifier;
import org.apache.camel.reifier.dataformat.FhirXmlDataFormatReifier;
import org.apache.camel.reifier.dataformat.FlatpackDataFormatReifier;
import org.apache.camel.reifier.dataformat.GrokDataFormatReifier;
import org.apache.camel.reifier.dataformat.GzipDataFormatReifier;
import org.apache.camel.reifier.dataformat.HL7DataFormatReifier;
import org.apache.camel.reifier.dataformat.IcalDataFormatReifier;
import org.apache.camel.reifier.dataformat.JacksonXMLDataFormatReifier;
import org.apache.camel.reifier.dataformat.JaxbDataFormatReifier;
import org.apache.camel.reifier.dataformat.JsonApiDataFormatReifier;
import org.apache.camel.reifier.dataformat.JsonDataFormatReifier;
import org.apache.camel.reifier.dataformat.LZFDataFormatReifier;
import org.apache.camel.reifier.dataformat.MimeMultipartDataFormatReifier;
import org.apache.camel.reifier.dataformat.PGPDataFormatReifier;
import org.apache.camel.reifier.dataformat.ParquetAvroDataFormatReifier;
import org.apache.camel.reifier.dataformat.ProtobufDataFormatReifier;
import org.apache.camel.reifier.dataformat.RssDataFormatReifier;
import org.apache.camel.reifier.dataformat.SoapDataFormatReifier;
import org.apache.camel.reifier.dataformat.SwiftMtDataFormatReifier;
import org.apache.camel.reifier.dataformat.SwiftMxDataFormatReifier;
import org.apache.camel.reifier.dataformat.SyslogDataFormatReifier;
import org.apache.camel.reifier.dataformat.TarFileDataFormatReifier;
import org.apache.camel.reifier.dataformat.ThriftDataFormatReifier;
import org.apache.camel.reifier.dataformat.TidyMarkupDataFormatReifier;
import org.apache.camel.reifier.dataformat.UniVocityCsvDataFormatReifier;
import org.apache.camel.reifier.dataformat.UniVocityFixedWidthDataFormatReifier;
import org.apache.camel.reifier.dataformat.UniVocityTsvDataFormatReifier;
import org.apache.camel.reifier.dataformat.XMLSecurityDataFormatReifier;
import org.apache.camel.reifier.dataformat.YAMLDataFormatReifier;
import org.apache.camel.reifier.dataformat.ZipDataFormatReifier;
import org.apache.camel.reifier.dataformat.ZipFileDataFormatReifier;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataFormatReifier<T extends DataFormatDefinition>
extends AbstractReifier {
    private static final Logger LOG = LoggerFactory.getLogger(DataFormatReifier.class);
    private static final Map<Class<? extends DataFormatDefinition>, BiFunction<CamelContext, DataFormatDefinition, DataFormatReifier<? extends DataFormatDefinition>>> DATAFORMATS = new HashMap<Class<? extends DataFormatDefinition>, BiFunction<CamelContext, DataFormatDefinition, DataFormatReifier<? extends DataFormatDefinition>>>(0);
    protected final T definition;

    public DataFormatReifier(CamelContext camelContext, T definition) {
        super(camelContext);
        this.definition = definition;
    }

    public static void registerReifier(Class<? extends DataFormatDefinition> dataFormatClass, BiFunction<CamelContext, DataFormatDefinition, DataFormatReifier<? extends DataFormatDefinition>> creator) {
        if (DATAFORMATS.isEmpty()) {
            ReifierStrategy.addReifierClearer(DataFormatReifier::clearReifiers);
        }
        DATAFORMATS.put(dataFormatClass, creator);
    }

    public static void clearReifiers() {
        DATAFORMATS.clear();
    }

    public static DataFormat getDataFormat(CamelContext camelContext, DataFormatDefinition type) {
        return DataFormatReifier.getDataFormat(camelContext, (DataFormatDefinition)ObjectHelper.notNull((Object)type, (String)"type"), null);
    }

    public static DataFormat getDataFormat(CamelContext camelContext, String ref) {
        return DataFormatReifier.getDataFormat(camelContext, null, (String)ObjectHelper.notNull((Object)ref, (String)"ref"));
    }

    public static DataFormat getDataFormat(CamelContext camelContext, DataFormatDefinition type, String ref) {
        if (type == null) {
            ObjectHelper.notNull((Object)ref, (String)"ref or type");
            DataFormat dataFormat = (DataFormat)CamelContextHelper.lookup((CamelContext)camelContext, (String)ref, DataFormat.class);
            if (dataFormat != null) {
                return dataFormat;
            }
            type = ((Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class)).resolveDataFormatDefinition(ref);
            if (type == null) {
                dataFormat = camelContext.resolveDataFormat(ref);
                if (dataFormat == null) {
                    throw new IllegalArgumentException("Cannot find data format in registry with ref: " + ref);
                }
                return dataFormat;
            }
        }
        if (type.getDataFormat() != null) {
            return type.getDataFormat();
        }
        return DataFormatReifier.reifier(camelContext, type).createDataFormat();
    }

    public static DataFormatReifier<? extends DataFormatDefinition> reifier(CamelContext camelContext, DataFormatDefinition definition) {
        BiFunction<CamelContext, DataFormatDefinition, DataFormatReifier<? extends DataFormatDefinition>> reifier;
        DataFormatReifier<DataFormatDefinition> answer = null;
        if (!DATAFORMATS.isEmpty() && (reifier = DATAFORMATS.get(definition.getClass())) != null) {
            answer = reifier.apply(camelContext, definition);
        }
        if (answer == null) {
            answer = DataFormatReifier.coreReifier(camelContext, definition);
        }
        if (answer == null) {
            throw new IllegalStateException("Unsupported definition: " + definition);
        }
        return answer;
    }

    private static DataFormatReifier<? extends DataFormatDefinition> coreReifier(CamelContext camelContext, DataFormatDefinition definition) {
        if (definition instanceof ASN1DataFormat) {
            return new ASN1DataFormatReifier(camelContext, definition);
        }
        if (definition instanceof AvroDataFormat) {
            return new AvroDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof BarcodeDataFormat) {
            return new BarcodeDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof Base64DataFormat) {
            return new Base64DataFormatReifier(camelContext, definition);
        }
        if (definition instanceof BeanioDataFormat) {
            return new BeanioDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof BindyDataFormat) {
            return new BindyDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof CBORDataFormat) {
            return new CBORDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof CryptoDataFormat) {
            return new CryptoDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof CsvDataFormat) {
            return new CsvDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof CustomDataFormat) {
            return new CustomDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof FhirJsonDataFormat) {
            return new FhirJsonDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof FhirXmlDataFormat) {
            return new FhirXmlDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof FhirDataformat) {
            return new FhirDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof FlatpackDataFormat) {
            return new FlatpackDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof GrokDataFormat) {
            return new GrokDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof GzipDeflaterDataFormat) {
            return new GzipDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof HL7DataFormat) {
            return new HL7DataFormatReifier(camelContext, definition);
        }
        if (definition instanceof IcalDataFormat) {
            return new IcalDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof JacksonXMLDataFormat) {
            return new JacksonXMLDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof JaxbDataFormat) {
            return new JaxbDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof JsonApiDataFormat) {
            return new JsonApiDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof JsonDataFormat) {
            return new JsonDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof LZFDataFormat) {
            return new LZFDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof MimeMultipartDataFormat) {
            return new MimeMultipartDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof ParquetAvroDataFormat) {
            return new ParquetAvroDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof PGPDataFormat) {
            return new PGPDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof ProtobufDataFormat) {
            return new ProtobufDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof RssDataFormat) {
            return new RssDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof SoapDataFormat) {
            return new SoapDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof SyslogDataFormat) {
            return new SyslogDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof SwiftMtDataFormat) {
            return new SwiftMtDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof SwiftMxDataFormat) {
            return new SwiftMxDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof TarFileDataFormat) {
            return new TarFileDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof ThriftDataFormat) {
            return new ThriftDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof TidyMarkupDataFormat) {
            return new TidyMarkupDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof UniVocityCsvDataFormat) {
            return new UniVocityCsvDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof UniVocityFixedDataFormat) {
            return new UniVocityFixedWidthDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof UniVocityTsvDataFormat) {
            return new UniVocityTsvDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof XMLSecurityDataFormat) {
            return new XMLSecurityDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof YAMLDataFormat) {
            return new YAMLDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof ZipDeflaterDataFormat) {
            return new ZipDataFormatReifier(camelContext, definition);
        }
        if (definition instanceof ZipFileDataFormat) {
            return new ZipFileDataFormatReifier(camelContext, definition);
        }
        return null;
    }

    public DataFormat createDataFormat() {
        DataFormat dataFormat = this.definition.getDataFormat();
        if (dataFormat == null) {
            dataFormat = this.doCreateDataFormat();
            if (dataFormat != null) {
                if (dataFormat instanceof DataFormatContentTypeHeader && this.definition instanceof ContentTypeHeaderAware) {
                    String header = ((ContentTypeHeaderAware)this.definition).getContentTypeHeader();
                    boolean contentTypeHeader = this.parseBoolean(header, true);
                    ((DataFormatContentTypeHeader)dataFormat).setContentTypeHeader(contentTypeHeader);
                }
                this.configureDataFormat(dataFormat);
            } else {
                throw new IllegalArgumentException("Data format '" + (this.definition.getDataFormatName() != null ? this.definition.getDataFormatName() : "<null>") + "' could not be created. Ensure that the data format is valid and the associated Camel component is present on the classpath");
            }
        }
        return dataFormat;
    }

    protected DataFormat doCreateDataFormat() {
        String dfn = this.definition.getDataFormatName();
        if (dfn != null) {
            return this.camelContext.createDataFormat(dfn);
        }
        return null;
    }

    private String getDataFormatName() {
        return this.definition.getDataFormatName();
    }

    protected void configureDataFormat(DataFormat dataFormat) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.prepareDataFormatConfig(properties);
        properties.entrySet().removeIf(e -> e.getValue() == null);
        PropertyConfigurer configurer = this.findPropertyConfigurer(dataFormat);
        PropertyBindingSupport.build().withCamelContext(this.camelContext).withTarget((Object)dataFormat).withReference(true).withMandatory(true).withIgnoreCase(true).withConfigurer(configurer).withProperties(properties).bind();
    }

    private PropertyConfigurer findPropertyConfigurer(DataFormat dataFormat) {
        PropertyConfigurer configurer = null;
        String name = this.getDataFormatName();
        LOG.trace("Discovering optional dataformat property configurer class for dataformat: {}", (Object)name);
        if (dataFormat instanceof PropertyConfigurerAware) {
            configurer = ((PropertyConfigurerAware)dataFormat).getPropertyConfigurer((Object)dataFormat);
            if (LOG.isDebugEnabled() && configurer != null) {
                LOG.debug("Discovered dataformat property configurer using the PropertyConfigurerAware: {} -> {}", (Object)name, (Object)configurer);
            }
        }
        if (configurer == null) {
            String configurerName = name + "-dataformat-configurer";
            configurer = PluginHelper.getConfigurerResolver((CamelContext)this.camelContext).resolvePropertyConfigurer(configurerName, this.camelContext);
        }
        return configurer;
    }

    protected abstract void prepareDataFormatConfig(Map<String, Object> var1);

    protected String asTypeName(Class<?> classType) {
        Object type = !classType.isPrimitive() ? (classType.isArray() ? StringHelper.between((String)classType.getName(), (String)"[L", (String)";") + "[]" : classType.getName()) : classType.getCanonicalName();
        return type;
    }
}

