/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.transformer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.model.transformer.CustomTransformerDefinition;
import org.apache.camel.model.transformer.DataFormatTransformerDefinition;
import org.apache.camel.model.transformer.EndpointTransformerDefinition;
import org.apache.camel.model.transformer.LoadTransformerDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.transformer.CustomTransformerReifier;
import org.apache.camel.reifier.transformer.DataFormatTransformerReifier;
import org.apache.camel.reifier.transformer.EndpointTransformerReifier;
import org.apache.camel.reifier.transformer.LoadTransformerReifier;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.spi.Transformer;

public abstract class TransformerReifier<T>
extends AbstractReifier {
    private static final Map<Class<?>, BiFunction<CamelContext, TransformerDefinition, TransformerReifier<? extends TransformerDefinition>>> TRANSFORMERS = new HashMap(0);
    protected final T definition;

    public TransformerReifier(CamelContext camelContext, T definition) {
        super(camelContext);
        this.definition = definition;
    }

    public static void registerReifier(Class<?> processorClass, BiFunction<CamelContext, TransformerDefinition, TransformerReifier<? extends TransformerDefinition>> creator) {
        if (TRANSFORMERS.isEmpty()) {
            ReifierStrategy.addReifierClearer(TransformerReifier::clearReifiers);
        }
        TRANSFORMERS.put(processorClass, creator);
    }

    public static TransformerReifier<? extends TransformerDefinition> reifier(CamelContext camelContext, TransformerDefinition definition) {
        BiFunction<CamelContext, TransformerDefinition, TransformerReifier<? extends TransformerDefinition>> reifier;
        TransformerReifier<TransformerDefinition> answer = null;
        if (!TRANSFORMERS.isEmpty() && (reifier = TRANSFORMERS.get(definition.getClass())) != null) {
            answer = reifier.apply(camelContext, definition);
        }
        if (answer == null) {
            answer = TransformerReifier.coreReifier(camelContext, definition);
        }
        if (answer == null) {
            throw new IllegalStateException("Unsupported definition: " + definition);
        }
        return answer;
    }

    private static TransformerReifier<? extends TransformerDefinition> coreReifier(CamelContext camelContext, TransformerDefinition definition) {
        if (definition instanceof CustomTransformerDefinition) {
            return new CustomTransformerReifier(camelContext, definition);
        }
        if (definition instanceof DataFormatTransformerDefinition) {
            return new DataFormatTransformerReifier(camelContext, definition);
        }
        if (definition instanceof EndpointTransformerDefinition) {
            return new EndpointTransformerReifier(camelContext, definition);
        }
        if (definition instanceof LoadTransformerDefinition) {
            return new LoadTransformerReifier(camelContext, definition);
        }
        return null;
    }

    public static void clearReifiers() {
        TRANSFORMERS.clear();
    }

    public Transformer createTransformer() {
        return this.doCreateTransformer();
    }

    protected abstract Transformer doCreateTransformer();
}

