/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.language.bean.BeanLanguage;
import org.apache.camel.language.simple.SimpleLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpressionBuilder {
    private ExpressionBuilder() {
    }

    public static <E extends Exchange> Expression<E> headerExpression(final String headerName) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                Object header = exchange.getIn().getHeader(headerName);
                if (header == null) {
                    header = exchange.getProperty(headerName);
                }
                return header;
            }

            public String toString() {
                return "header(" + headerName + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> headersExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getIn().getHeaders();
            }

            public String toString() {
                return "headers";
            }
        };
    }

    public static <E extends Exchange> Expression<E> outHeaderExpression(final String headerName) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                Message out = exchange.getOut(false);
                if (out == null) {
                    return null;
                }
                Object header = out.getHeader(headerName);
                if (header == null) {
                    header = exchange.getProperty(headerName);
                }
                return header;
            }

            public String toString() {
                return "outHeader(" + headerName + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> outHeadersExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getOut().getHeaders();
            }

            public String toString() {
                return "outHeaders";
            }
        };
    }

    public static <E extends Exchange> Expression<E> propertyExpression(final String propertyName) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getProperty(propertyName);
            }

            public String toString() {
                return "property(" + propertyName + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> propertiesExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getProperties();
            }

            public String toString() {
                return "properties";
            }
        };
    }

    public static <E extends Exchange> Expression<E> systemPropertyExpression(String propertyName) {
        return ExpressionBuilder.systemPropertyExpression(propertyName, null);
    }

    public static <E extends Exchange> Expression<E> systemPropertyExpression(final String propertyName, final String defaultValue) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return System.getProperty(propertyName, defaultValue);
            }

            public String toString() {
                return "systemProperty(" + propertyName + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> constantExpression(final Object value) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return value;
            }

            public String toString() {
                return "" + value;
            }
        };
    }

    public static <E extends Exchange> Expression<E> bodyExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getIn().getBody();
            }

            public String toString() {
                return "body";
            }
        };
    }

    public static <E extends Exchange, T> Expression<E> bodyExpression(final Class<T> type) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getIn().getBody(type);
            }

            public String toString() {
                return "bodyAs[" + type.getName() + "]";
            }
        };
    }

    public static <E extends Exchange> Expression<E> outBodyExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                Message out = exchange.getOut(false);
                if (out == null) {
                    return null;
                }
                return out.getBody();
            }

            public String toString() {
                return "outBody";
            }
        };
    }

    public static <E extends Exchange, T> Expression<E> outBodyExpression(final Class<T> type) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                Message out = exchange.getOut(false);
                if (out == null) {
                    return null;
                }
                return out.getBody(type);
            }

            public String toString() {
                return "outBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static <E extends Exchange> Expression<E> faultBodyExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getFault().getBody();
            }

            public String toString() {
                return "faultBody";
            }
        };
    }

    public static <E extends Exchange, T> Expression<E> faultBodyExpression(final Class<T> type) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getFault().getBody(type);
            }

            public String toString() {
                return "faultBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static <E extends Exchange> Expression<E> exchangeExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange;
            }

            public String toString() {
                return "exchange";
            }
        };
    }

    public static <E extends Exchange> Expression<E> inMessageExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getIn();
            }

            public String toString() {
                return "inMessage";
            }
        };
    }

    public static <E extends Exchange> Expression<E> outMessageExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getOut();
            }

            public String toString() {
                return "outMessage";
            }
        };
    }

    public static <E extends Exchange> Expression<E> convertTo(final Expression expression, final Class type) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                Object value = expression.evaluate(exchange);
                return exchange.getContext().getTypeConverter().convertTo(type, (Exchange)exchange, value);
            }

            public String toString() {
                return "" + expression + ".convertTo(" + type.getName() + ".class)";
            }
        };
    }

    public static <E extends Exchange> Expression<E> tokenizeExpression(final Expression<E> expression, final String token) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                Object value = expression.evaluate(exchange);
                Scanner scanner = ExpressionBuilder.getScanner(exchange, value);
                scanner.useDelimiter(token);
                return scanner;
            }

            public String toString() {
                return "tokenize(" + expression + ", " + token + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> regexTokenize(final Expression<E> expression, final String regexTokenizer) {
        final Pattern pattern = Pattern.compile(regexTokenizer);
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                Object value = expression.evaluate(exchange);
                Scanner scanner = ExpressionBuilder.getScanner(exchange, value);
                scanner.useDelimiter(regexTokenizer);
                return scanner;
            }

            public String toString() {
                return "regexTokenize(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    private static Scanner getScanner(Exchange exchange, Object value) {
        String text;
        String charset = exchange.getProperty("org.apache.camel.Exchange.CharsetName", String.class);
        Scanner scanner = null;
        if (value instanceof Readable) {
            scanner = new Scanner((Readable)value);
        } else if (value instanceof InputStream) {
            scanner = charset == null ? new Scanner((InputStream)value) : new Scanner((InputStream)value, charset);
        } else if (value instanceof File) {
            try {
                scanner = charset == null ? new Scanner((File)value) : new Scanner((File)value, charset);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeCamelException(e);
            }
        } else if (value instanceof String) {
            scanner = new Scanner((String)value);
        } else if (value instanceof ReadableByteChannel) {
            Scanner scanner2 = scanner = charset == null ? new Scanner((ReadableByteChannel)value) : new Scanner((ReadableByteChannel)value, charset);
        }
        if (scanner == null && (text = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, value)) != null) {
            scanner = new Scanner(text);
        }
        if (scanner == null) {
            scanner = new Scanner("");
        }
        return scanner;
    }

    public static <E extends Exchange> Expression<E> regexReplaceAll(final Expression<E> expression, String regex, final String replacement) {
        final Pattern pattern = Pattern.compile(regex);
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                String text = ExpressionBuilder.evaluateStringExpression(expression, exchange);
                if (text == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> regexReplaceAll(final Expression<E> expression, String regex, final Expression<E> replacementExpression) {
        final Pattern pattern = Pattern.compile(regex);
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                String text = ExpressionBuilder.evaluateStringExpression(expression, exchange);
                String replacement = ExpressionBuilder.evaluateStringExpression(replacementExpression, exchange);
                if (text == null || replacement == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> append(final Expression<E> left, final Expression<E> right) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return ExpressionBuilder.evaluateStringExpression(left, exchange) + ExpressionBuilder.evaluateStringExpression(right, exchange);
            }

            public String toString() {
                return "append(" + left + ", " + right + ")";
            }
        };
    }

    public static <E extends Exchange> String evaluateStringExpression(Expression<E> expression, E exchange) {
        Object value = expression.evaluate(exchange);
        return exchange.getContext().getTypeConverter().convertTo(String.class, exchange, value);
    }

    public static <E extends Exchange> Expression<E> systemProperty(String name) {
        return ExpressionBuilder.systemProperty(name, null);
    }

    public static <E extends Exchange> Expression<E> systemProperty(final String name, final String defaultValue) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return System.getProperty(name, defaultValue);
            }
        };
    }

    public static <E extends Exchange> Expression<E> concatExpression(Collection<Expression> expressions) {
        return ExpressionBuilder.concatExpression(expressions, null);
    }

    public static <E extends Exchange> Expression<E> concatExpression(final Collection<Expression> expressions, final String expression) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                StringBuffer buffer = new StringBuffer();
                for (Expression expression2 : expressions) {
                    String text = ExpressionBuilder.evaluateStringExpression(expression2, exchange);
                    if (text == null) continue;
                    buffer.append(text);
                }
                return buffer.toString();
            }

            public String toString() {
                if (expression != null) {
                    return expression;
                }
                return "concat" + expressions;
            }
        };
    }

    public static <E extends Exchange> Expression<E> messageIdExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getIn().getMessageId();
            }

            public String toString() {
                return "messageId";
            }
        };
    }

    public static <E extends Exchange> Expression<E> dateExpression(final String command, final String pattern) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                String key;
                Date date;
                if ("now".equals(command)) {
                    date = new Date();
                } else if (command.startsWith("header.") || command.startsWith("in.header.")) {
                    key = command.substring(command.lastIndexOf(".") + 1);
                    date = exchange.getIn().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Could not find java.util.Date object at " + command);
                    }
                } else if (command.startsWith("out.header.")) {
                    key = command.substring(command.lastIndexOf(".") + 1);
                    date = exchange.getOut().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Could not find java.util.Date object at " + command);
                    }
                } else {
                    throw new IllegalArgumentException("Command not supported for dateExpression: " + command);
                }
                SimpleDateFormat df = new SimpleDateFormat(pattern);
                return df.format(date);
            }

            public String toString() {
                return "date(" + command + ":" + pattern + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> simpleExpression(final String simple) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return SimpleLanguage.simple(simple).evaluate(exchange);
            }

            public String toString() {
                return "simple(" + simple + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> beanExpression(final String bean) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return BeanLanguage.bean(bean).evaluate(exchange);
            }

            public String toString() {
                return "bean(" + bean + ")";
            }
        };
    }
}

