/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.file.FileMessage;
import org.apache.camel.impl.DefaultExchange;

public class FileExchange
extends DefaultExchange {
    private File file;

    public FileExchange(CamelContext camelContext, ExchangePattern pattern, File file) {
        super(camelContext, pattern);
        this.setIn(new FileMessage(file));
        this.file = file;
        if (file != null) {
            this.getIn().setHeader("CamelFileName", file.getName());
            this.getIn().setHeader("CamelFileAbsolutePath", file.getAbsolutePath());
            this.getIn().setHeader("CamelFileParent", file.getParent());
            this.getIn().setHeader("CamelFilePath", file.getPath());
            try {
                this.getIn().setHeader("CamelFileCanonicalPath", file.getCanonicalPath());
            }
            catch (IOException e) {
                // empty catch block
            }
            if (file.length() > 0L) {
                this.getIn().setHeader("CamelFileLength", new Long(file.length()));
            }
            if (file.lastModified() > 0L) {
                this.getIn().setHeader("CamelFileLastModified", new Date(file.lastModified()));
            }
        }
    }

    public FileExchange(DefaultExchange parent, File file) {
        super(parent);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Exchange newInstance() {
        return new FileExchange(this, this.getFile());
    }
}

