/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mock.AssertionClause;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ExpressionComparator;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockEndpoint
extends DefaultEndpoint<Exchange>
implements BrowsableEndpoint<Exchange> {
    private static final transient Log LOG = LogFactory.getLog(MockEndpoint.class);
    private int expectedCount;
    private int counter;
    private Processor defaultProcessor;
    private Map<Integer, Processor> processors;
    private List<Exchange> receivedExchanges;
    private List<Throwable> failures;
    private List<Runnable> tests;
    private CountDownLatch latch;
    private long sleepForEmptyTest;
    private long resultWaitTime;
    private int expectedMinimumCount;
    private List expectedBodyValues;
    private List actualBodyValues;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String headerName;
    private String headerValue;
    private Object actualHeader;
    private Processor reporter;

    public MockEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.init();
    }

    public MockEndpoint(String endpointUri) {
        super(endpointUri);
        this.init();
    }

    public static MockEndpoint resolve(CamelContext context, String uri) {
        return CamelContextHelper.getMandatoryEndpoint(context, uri, MockEndpoint.class);
    }

    public static void assertWait(long timeout, TimeUnit unit, MockEndpoint ... endpoints) throws InterruptedException {
        long start = System.currentTimeMillis();
        long left = unit.toMillis(timeout);
        long end = start + left;
        for (MockEndpoint endpoint : endpoints) {
            if (!endpoint.await(left, TimeUnit.MILLISECONDS)) {
                throw new AssertionError((Object)("Timeout waiting for endpoints to receive enough messages. " + endpoint.getEndpointUri() + " timed out."));
            }
            left = end - System.currentTimeMillis();
            if (left > 0L) continue;
            left = 0L;
        }
    }

    public static void assertIsSatisfied(long timeout, TimeUnit unit, MockEndpoint ... endpoints) throws InterruptedException {
        MockEndpoint.assertWait(timeout, unit, endpoints);
        for (MockEndpoint endpoint : endpoints) {
            endpoint.assertIsSatisfied();
        }
    }

    public static void assertIsSatisfied(MockEndpoint ... endpoints) throws InterruptedException {
        for (MockEndpoint endpoint : endpoints) {
            endpoint.assertIsSatisfied();
        }
    }

    public static void assertIsSatisfied(CamelContext context) throws InterruptedException {
        ObjectHelper.notNull(context, "camelContext");
        Collection<Endpoint> endpoints = context.getSingletonEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (!(endpoint instanceof MockEndpoint)) continue;
            MockEndpoint mockEndpoint = (MockEndpoint)endpoint;
            mockEndpoint.assertIsSatisfied();
        }
    }

    public static void expectsMessageCount(int count, MockEndpoint ... endpoints) throws InterruptedException {
        for (MockEndpoint endpoint : endpoints) {
            MockEndpoint.expectsMessageCount(count, new MockEndpoint[0]);
        }
    }

    @Override
    public List<Exchange> getExchanges() {
        return this.getReceivedExchanges();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public Consumer<Exchange> createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume from this endpoint");
    }

    @Override
    public Producer<Exchange> createProducer() throws Exception {
        return new DefaultProducer<Exchange>((Endpoint)this){

            @Override
            public void process(Exchange exchange) {
                MockEndpoint.this.onExchange(exchange);
            }
        };
    }

    public void reset() {
        this.init();
    }

    public void whenExchangeReceived(int index, Processor processor) {
        this.processors.put(index, processor);
    }

    public void whenAnyExchangeReceived(Processor processor) {
        this.defaultProcessor = processor;
    }

    public void assertIsSatisfied() throws InterruptedException {
        this.assertIsSatisfied(this.sleepForEmptyTest);
    }

    public void assertIsSatisfied(long timeoutForEmptyEndpoints) throws InterruptedException {
        LOG.info((Object)("Asserting: " + this + " is satisfied"));
        if (this.expectedCount >= 0) {
            if (this.expectedCount != this.getReceivedCounter()) {
                if (this.expectedCount == 0) {
                    if (timeoutForEmptyEndpoints > 0L) {
                        LOG.debug((Object)("Sleeping for: " + timeoutForEmptyEndpoints + " millis to check there really are no messages received"));
                        Thread.sleep(timeoutForEmptyEndpoints);
                    }
                } else {
                    this.waitForCompleteLatch();
                }
            }
            this.assertEquals("Received message count", this.expectedCount, this.getReceivedCounter());
        } else if (this.expectedMinimumCount > 0 && this.getReceivedCounter() < this.expectedMinimumCount) {
            this.waitForCompleteLatch();
        }
        if (this.expectedMinimumCount >= 0) {
            int receivedCounter = this.getReceivedCounter();
            this.assertTrue("Received message count " + receivedCounter + ", expected at least " + this.expectedCount, this.expectedCount <= receivedCounter);
        }
        for (Runnable test : this.tests) {
            test.run();
        }
        for (Throwable failure : this.failures) {
            if (failure == null) continue;
            LOG.error((Object)("Caught on " + this.getEndpointUri() + " Exception: " + failure), failure);
            this.fail("Failed due to caught exception: " + failure);
        }
    }

    public void assertIsNotSatisfied() throws InterruptedException {
        try {
            this.assertIsSatisfied();
            this.fail("Expected assertion failure!");
        }
        catch (AssertionError e) {
            LOG.info((Object)("Caught expected failure: " + e));
        }
    }

    public void expectedMessageCount(int expectedCount) {
        this.setExpectedMessageCount(expectedCount);
    }

    public void expectedMinimumMessageCount(int expectedCount) {
        this.setMinimumExpectedMessageCount(expectedCount);
    }

    public void expectedHeaderReceived(String name, String value) {
        this.headerName = name;
        this.headerValue = value;
        this.expects(new Runnable(){

            public void run() {
                MockEndpoint.this.assertTrue("No header with name " + MockEndpoint.this.headerName + " found.", MockEndpoint.this.actualHeader != null);
                MockEndpoint.this.assertEquals("Header of message", MockEndpoint.this.headerValue, MockEndpoint.this.actualHeader);
            }
        });
    }

    public void expectedBodiesReceived(List bodies) {
        this.expectedMessageCount(bodies.size());
        this.expectedBodyValues = bodies;
        this.actualBodyValues = new ArrayList();
        this.expects(new Runnable(){

            public void run() {
                for (int i = 0; i < MockEndpoint.this.expectedBodyValues.size(); ++i) {
                    Exchange exchange = MockEndpoint.this.getReceivedExchanges().get(i);
                    MockEndpoint.this.assertTrue("No exchange received for counter: " + i, exchange != null);
                    Object expectedBody = MockEndpoint.this.expectedBodyValues.get(i);
                    Object actualBody = MockEndpoint.this.actualBodyValues.get(i);
                    MockEndpoint.this.assertEquals("Body of message: " + i, expectedBody, actualBody);
                }
            }
        });
    }

    public void expectedBodiesReceived(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        this.expectedBodiesReceived(bodyList);
    }

    public void expectedBodiesReceivedInAnyOrder(List bodies) {
        this.expectedMessageCount(bodies.size());
        this.expectedBodyValues = bodies;
        this.actualBodyValues = new ArrayList();
        this.expects(new Runnable(){

            public void run() {
                HashSet actualBodyValuesSet = new HashSet(MockEndpoint.this.actualBodyValues);
                for (int i = 0; i < MockEndpoint.this.expectedBodyValues.size(); ++i) {
                    Exchange exchange = MockEndpoint.this.getReceivedExchanges().get(i);
                    MockEndpoint.this.assertTrue("No exchange received for counter: " + i, exchange != null);
                    Object expectedBody = MockEndpoint.this.expectedBodyValues.get(i);
                    MockEndpoint.this.assertTrue("Message with body " + expectedBody + " was expected but not found in " + actualBodyValuesSet, actualBodyValuesSet.remove(expectedBody));
                }
            }
        });
    }

    public void expectedBodiesReceivedInAnyOrder(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        this.expectedBodiesReceivedInAnyOrder(bodyList);
    }

    public void expectsAscending(final Expression<Exchange> expression) {
        this.expects(new Runnable(){

            public void run() {
                MockEndpoint.this.assertMessagesAscending(expression);
            }
        });
    }

    public void expectsDescending(final Expression<Exchange> expression) {
        this.expects(new Runnable(){

            public void run() {
                MockEndpoint.this.assertMessagesDescending(expression);
            }
        });
    }

    public void expectsNoDuplicates(final Expression<Exchange> expression) {
        this.expects(new Runnable(){

            public void run() {
                MockEndpoint.this.assertNoDuplicates(expression);
            }
        });
    }

    public void assertMessagesAscending(Expression<Exchange> expression) {
        this.assertMessagesSorted(expression, true);
    }

    public void assertMessagesDescending(Expression<Exchange> expression) {
        this.assertMessagesSorted(expression, false);
    }

    protected void assertMessagesSorted(Expression<Exchange> expression, boolean ascending) {
        String type = ascending ? "ascending" : "descending";
        ExpressionComparator<Exchange> comparator = new ExpressionComparator<Exchange>(expression);
        List<Exchange> list = this.getReceivedExchanges();
        for (int i = 1; i < list.size(); ++i) {
            Exchange e2;
            int j = i - 1;
            Exchange e1 = list.get(j);
            int result = comparator.compare(e1, e2 = list.get(i));
            if (result == 0) {
                this.fail("Messages not " + type + ". Messages" + j + " and " + i + " are equal with value: " + expression.evaluate(e1) + " for expression: " + expression + ". Exchanges: " + e1 + " and " + e2);
                continue;
            }
            if (!ascending) {
                result *= -1;
            }
            if (result <= 0) continue;
            this.fail("Messages not " + type + ". Message " + j + " has value: " + expression.evaluate(e1) + " and message " + i + " has value: " + expression.evaluate(e2) + " for expression: " + expression + ". Exchanges: " + e1 + " and " + e2);
        }
    }

    public void assertNoDuplicates(Expression<Exchange> expression) {
        HashMap<Object, Exchange> map = new HashMap<Object, Exchange>();
        List<Exchange> list = this.getReceivedExchanges();
        for (int i = 0; i < list.size(); ++i) {
            Exchange e2 = list.get(i);
            Object key = expression.evaluate(e2);
            Exchange e1 = (Exchange)map.get(key);
            if (e1 != null) {
                this.fail("Duplicate message found on message " + i + " has value: " + key + " for expression: " + expression + ". Exchanges: " + e1 + " and " + e2);
                continue;
            }
            map.put(key, e2);
        }
    }

    public void expects(Runnable runnable) {
        this.tests.add(runnable);
    }

    public AssertionClause message(final int messageIndex) {
        AssertionClause clause = new AssertionClause(){

            public void run() {
                this.applyAssertionOn(MockEndpoint.this, messageIndex, MockEndpoint.this.assertExchangeReceived(messageIndex));
            }
        };
        this.expects(clause);
        return clause;
    }

    public AssertionClause allMessages() {
        AssertionClause clause = new AssertionClause(){

            public void run() {
                List<Exchange> list = MockEndpoint.this.getReceivedExchanges();
                int index = 0;
                for (Exchange exchange : list) {
                    this.applyAssertionOn(MockEndpoint.this, index++, exchange);
                }
            }
        };
        this.expects(clause);
        return clause;
    }

    public Exchange assertExchangeReceived(int index) {
        int count = this.getReceivedCounter();
        this.assertTrue("Not enough messages received. Was: " + count, count > index);
        return this.getReceivedExchanges().get(index);
    }

    public List<Throwable> getFailures() {
        return this.failures;
    }

    public int getReceivedCounter() {
        return this.getReceivedExchanges().size();
    }

    public List<Exchange> getReceivedExchanges() {
        return this.receivedExchanges;
    }

    public int getExpectedCount() {
        return this.expectedCount;
    }

    public long getSleepForEmptyTest() {
        return this.sleepForEmptyTest;
    }

    public void setSleepForEmptyTest(long sleepForEmptyTest) {
        this.sleepForEmptyTest = sleepForEmptyTest;
    }

    public long getResultWaitTime() {
        return this.resultWaitTime;
    }

    public void setResultWaitTime(long resultWaitTime) {
        this.resultWaitTime = resultWaitTime;
    }

    public void setExpectedMessageCount(int expectedCount) {
        this.expectedCount = expectedCount;
        this.latch = expectedCount <= 0 ? null : new CountDownLatch(expectedCount);
    }

    public void setMinimumExpectedMessageCount(int expectedCount) {
        this.expectedMinimumCount = expectedCount;
        this.latch = expectedCount <= 0 ? null : new CountDownLatch(this.expectedMinimumCount);
    }

    public Processor getReporter() {
        return this.reporter;
    }

    public void setReporter(Processor reporter) {
        this.reporter = reporter;
    }

    private void init() {
        this.expectedCount = -1;
        this.counter = 0;
        this.processors = new HashMap<Integer, Processor>();
        this.receivedExchanges = new CopyOnWriteArrayList<Exchange>();
        this.failures = new CopyOnWriteArrayList<Throwable>();
        this.tests = new CopyOnWriteArrayList<Runnable>();
        this.latch = null;
        this.sleepForEmptyTest = 1000L;
        this.resultWaitTime = 20000L;
        this.expectedMinimumCount = -1;
        this.expectedBodyValues = null;
        this.actualBodyValues = new ArrayList();
    }

    protected synchronized void onExchange(Exchange exchange) {
        try {
            if (this.reporter != null) {
                this.reporter.process(exchange);
            }
            this.performAssertions(exchange);
        }
        catch (Throwable e) {
            this.failures.add(e);
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
    }

    protected void performAssertions(Exchange exchange) throws Exception {
        Processor processor;
        Message in = exchange.getIn();
        Object actualBody = in.getBody();
        if (this.headerName != null) {
            this.actualHeader = in.getHeader(this.headerName);
        }
        if (this.expectedBodyValues != null) {
            int index = this.actualBodyValues.size();
            if (this.expectedBodyValues.size() > index) {
                Object expectedBody = this.expectedBodyValues.get(index);
                if (expectedBody != null) {
                    actualBody = in.getBody(expectedBody.getClass());
                }
                this.actualBodyValues.add(actualBody);
            }
        }
        LOG.debug((Object)(this.getEndpointUri() + " >>>> " + ++this.counter + " : " + exchange + " with body: " + actualBody));
        this.receivedExchanges.add(exchange);
        Processor processor2 = processor = this.processors.get(this.getReceivedCounter()) != null ? this.processors.get(this.getReceivedCounter()) : this.defaultProcessor;
        if (processor != null) {
            processor.process(exchange);
        }
    }

    protected void waitForCompleteLatch() throws InterruptedException {
        if (this.latch == null) {
            this.fail("Should have a latch!");
        }
        LOG.debug((Object)("Waiting on the latch for: " + this.resultWaitTime + " millis"));
        this.latch.await(this.resultWaitTime, TimeUnit.MILLISECONDS);
    }

    protected void assertEquals(String message, Object expectedValue, Object actualValue) {
        if (!ObjectHelper.equal(expectedValue, actualValue)) {
            this.fail(message + ". Expected: <" + expectedValue + "> but was: <" + actualValue + ">");
        }
    }

    protected void assertTrue(String message, boolean predicate) {
        if (!predicate) {
            this.fail(message);
        }
    }

    protected void fail(Object message) {
        if (LOG.isDebugEnabled()) {
            List<Exchange> list = this.getReceivedExchanges();
            int index = 0;
            for (Exchange exchange : list) {
                LOG.debug((Object)("Received[" + ++index + "]: " + exchange));
            }
        }
        throw new AssertionError((Object)(this.getEndpointUri() + " " + message));
    }

    public int getExpectedMinimumCount() {
        return this.expectedMinimumCount;
    }

    public void await() throws InterruptedException {
        if (this.latch != null) {
            this.latch.await();
        }
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.latch != null) {
            return this.latch.await(timeout, unit);
        }
        return true;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

