/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProducerTemplate<E extends Exchange>
extends ServiceSupport
implements ProducerTemplate<E> {
    private CamelContext context;
    private final ProducerCache<E> producerCache = new ProducerCache();
    private boolean useEndpointCache = true;
    private final Map<String, Endpoint<E>> endpointCache = new HashMap<String, Endpoint<E>>();
    private Endpoint<E> defaultEndpoint;

    public DefaultProducerTemplate(CamelContext context) {
        this.context = context;
    }

    public DefaultProducerTemplate(CamelContext context, Endpoint defaultEndpoint) {
        this(context);
        this.defaultEndpoint = defaultEndpoint;
    }

    @Override
    public E send(String endpointUri, E exchange) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, exchange);
    }

    @Override
    public E send(String endpointUri, Processor processor) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, processor);
    }

    @Override
    public E send(String endpointUri, Processor processor, AsyncCallback callback) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, processor, callback);
    }

    @Override
    public E send(String endpointUri, ExchangePattern pattern, Processor processor) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, pattern, processor);
    }

    @Override
    public E send(Endpoint<E> endpoint, E exchange) {
        E convertedExchange = exchange;
        this.producerCache.send(endpoint, convertedExchange);
        return convertedExchange;
    }

    @Override
    public E send(Endpoint<E> endpoint, Processor processor) {
        return this.producerCache.send(endpoint, processor);
    }

    @Override
    public E send(Endpoint<E> endpoint, Processor processor, AsyncCallback callback) {
        return this.producerCache.send(endpoint, processor, callback);
    }

    @Override
    public E send(Endpoint<E> endpoint, ExchangePattern pattern, Processor processor) {
        return this.producerCache.send(endpoint, pattern, processor);
    }

    @Override
    public Object sendBody(Endpoint<E> endpoint, ExchangePattern pattern, Object body) {
        E result = this.send(endpoint, pattern, this.createSetBodyProcessor(body));
        return this.extractResultBody(result, pattern);
    }

    @Override
    public Object sendBody(Endpoint<E> endpoint, Object body) {
        E result = this.send(endpoint, this.createSetBodyProcessor(body));
        return this.extractResultBody(result);
    }

    @Override
    public Object sendBody(String endpointUri, Object body) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.sendBody(endpoint, body);
    }

    @Override
    public Object sendBody(String endpointUri, ExchangePattern pattern, Object body) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.sendBody(endpoint, pattern, body);
    }

    @Override
    public Object sendBodyAndHeader(String endpointUri, Object body, String header, Object headerValue) {
        return this.sendBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), body, header, headerValue);
    }

    @Override
    public Object sendBodyAndHeader(Endpoint endpoint, Object body, String header, Object headerValue) {
        E result = this.send(endpoint, this.createBodyAndHeaderProcessor(body, header, headerValue));
        return this.extractResultBody(result);
    }

    @Override
    public Object sendBodyAndHeader(Endpoint endpoint, ExchangePattern pattern, Object body, String header, Object headerValue) {
        E result = this.send(endpoint, pattern, this.createBodyAndHeaderProcessor(body, header, headerValue));
        return this.extractResultBody(result, pattern);
    }

    @Override
    public Object sendBodyAndHeader(String endpoint, ExchangePattern pattern, Object body, String header, Object headerValue) {
        E result = this.send(endpoint, pattern, this.createBodyAndHeaderProcessor(body, header, headerValue));
        return this.extractResultBody(result, pattern);
    }

    @Override
    public Object sendBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body, headers);
    }

    @Override
    public Object sendBodyAndHeaders(Endpoint endpoint, final Object body, final Map<String, Object> headers) {
        E result = this.send(endpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                for (Map.Entry header : headers.entrySet()) {
                    in.setHeader((String)header.getKey(), header.getValue());
                }
                in.setBody(body);
            }
        });
        return this.extractResultBody(result);
    }

    @Override
    public E request(Endpoint<E> endpoint, Processor processor) {
        return this.send(endpoint, ExchangePattern.InOut, processor);
    }

    @Override
    public Object requestBody(Endpoint<E> endpoint, Object body) {
        return this.sendBody(endpoint, ExchangePattern.InOut, body);
    }

    @Override
    public Object requestBodyAndHeader(Endpoint<E> endpoint, Object body, String header, Object headerValue) {
        return this.sendBodyAndHeader(endpoint, ExchangePattern.InOut, body, header, headerValue);
    }

    @Override
    public E request(String endpoint, Processor processor) {
        return this.send(endpoint, ExchangePattern.InOut, processor);
    }

    @Override
    public Object requestBody(String endpoint, Object body) {
        return this.sendBody(endpoint, ExchangePattern.InOut, body);
    }

    @Override
    public Object requestBodyAndHeader(String endpoint, Object body, String header, Object headerValue) {
        return this.sendBodyAndHeader(endpoint, ExchangePattern.InOut, body, header, headerValue);
    }

    @Override
    public Object sendBody(Object body) {
        return this.sendBody(this.getMandatoryDefaultEndpoint(), body);
    }

    @Override
    public E send(E exchange) {
        return this.send(this.getMandatoryDefaultEndpoint(), exchange);
    }

    @Override
    public E send(Processor processor) {
        return this.send(this.getMandatoryDefaultEndpoint(), processor);
    }

    @Override
    public Object sendBodyAndHeader(Object body, String header, Object headerValue) {
        return this.sendBodyAndHeader(this.getMandatoryDefaultEndpoint(), body, header, headerValue);
    }

    @Override
    public Object sendBodyAndHeaders(Object body, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(this.getMandatoryDefaultEndpoint(), body, headers);
    }

    public Producer<E> getProducer(Endpoint<E> endpoint) {
        return this.producerCache.getProducer(endpoint);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Endpoint<E> getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(Endpoint<E> defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public void setDefaultEndpointUri(String endpointUri) {
        this.setDefaultEndpoint(this.getContext().getEndpoint(endpointUri));
    }

    public boolean isUseEndpointCache() {
        return this.useEndpointCache;
    }

    public void setUseEndpointCache(boolean useEndpointCache) {
        this.useEndpointCache = useEndpointCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Endpoint<?>> T getResolvedEndpoint(String endpointUri, Class<T> expectedClass) {
        Endpoint<E> e = null;
        Map<String, Endpoint<E>> map = this.endpointCache;
        synchronized (map) {
            e = this.endpointCache.get(endpointUri);
        }
        if (e != null && expectedClass.isAssignableFrom(e.getClass())) {
            return (T)((Endpoint)expectedClass.asSubclass(expectedClass).cast(e));
        }
        return null;
    }

    protected Processor createBodyAndHeaderProcessor(final Object body, final String header, final Object headerValue) {
        return new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setHeader(header, headerValue);
                in.setBody(body);
            }
        };
    }

    protected Processor createSetBodyProcessor(final Object body) {
        return new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Endpoint resolveMandatoryEndpoint(String endpointUri) {
        Endpoint endpoint = null;
        if (this.isUseEndpointCache()) {
            Map<String, Endpoint<E>> map = this.endpointCache;
            synchronized (map) {
                endpoint = this.endpointCache.get(endpointUri);
                if (endpoint == null && (endpoint = this.context.getEndpoint(endpointUri)) != null) {
                    this.endpointCache.put(endpointUri, endpoint);
                }
            }
        } else {
            endpoint = this.context.getEndpoint(endpointUri);
        }
        if (endpoint == null) {
            throw new NoSuchEndpointException(endpointUri);
        }
        return endpoint;
    }

    protected Endpoint<E> getMandatoryDefaultEndpoint() {
        Endpoint<E> answer = this.getDefaultEndpoint();
        ObjectHelper.notNull(answer, "defaultEndpoint");
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
        this.producerCache.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.producerCache.stop();
        this.endpointCache.clear();
    }

    protected Object extractResultBody(E result) {
        return this.extractResultBody(result, null);
    }

    protected Object extractResultBody(E result, ExchangePattern pattern) {
        Object answer = null;
        if (result != null) {
            if (result.getException() != null) {
                throw ObjectHelper.wrapRuntimeCamelException(result.getException());
            }
            if (this.hasFaultMessage(result)) {
                return result.getFault().getBody();
            }
            boolean notOut = pattern != null && !pattern.isOutCapable();
            boolean hasOut = result.getOut(false) != null;
            answer = hasOut && !notOut ? result.getOut().getBody() : result.getIn().getBody();
        }
        return answer;
    }

    protected boolean hasFaultMessage(E result) {
        Object faultBody;
        Message faultMessage = result.getFault(false);
        return faultMessage != null && (faultBody = faultMessage.getBody()) != null;
    }
}

