/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScheduledPollConsumer<E extends Exchange>
extends DefaultConsumer<E>
implements Runnable {
    private static final transient Log LOG = LogFactory.getLog(ScheduledPollConsumer.class);
    private final ScheduledExecutorService executor;
    private long initialDelay = 1000L;
    private long delay = 500L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private boolean useFixedDelay;
    private ScheduledFuture<?> future;
    private Exception firstExceptionThrown;

    public ScheduledPollConsumer(DefaultEndpoint<E> endpoint, Processor processor) {
        this(endpoint, processor, endpoint.getExecutorService());
    }

    public ScheduledPollConsumer(Endpoint<E> endpoint, Processor processor, ScheduledExecutorService executor) {
        super(endpoint, processor);
        this.executor = executor;
        if (executor == null) {
            throw new IllegalArgumentException("A non null ScheduledExecutorService must be provided.");
        }
    }

    @Override
    public void run() {
        block3: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Starting to poll: " + this.getEndpoint()));
            }
            try {
                this.poll();
            }
            catch (Exception e) {
                LOG.warn((Object)("An exception occured while polling: " + this.getEndpoint() + ": " + e.getMessage()), (Throwable)e);
                if (this.firstExceptionThrown != null) break block3;
                this.firstExceptionThrown = e;
            }
        }
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isUseFixedDelay() {
        return this.useFixedDelay;
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.useFixedDelay = useFixedDelay;
    }

    protected abstract void poll() throws Exception;

    @Override
    protected void doStart() throws Exception {
        this.firstExceptionThrown = null;
        super.doStart();
        this.future = this.isUseFixedDelay() ? this.executor.scheduleWithFixedDelay(this, this.getInitialDelay(), this.getDelay(), this.getTimeUnit()) : this.executor.scheduleAtFixedRate(this, this.getInitialDelay(), this.getDelay(), this.getTimeUnit());
    }

    @Override
    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(false);
        }
        super.doStop();
        if (this.firstExceptionThrown != null) {
            throw this.firstExceptionThrown;
        }
    }
}

