/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.idempotent.IdempotentConsumer;
import org.apache.camel.processor.idempotent.MessageIdRepository;
import org.apache.camel.spi.RouteContext;

@XmlRootElement(name="idempotentConsumer")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IdempotentConsumerType
extends ExpressionNode {
    @XmlAttribute
    private String messageIdRepositoryRef;
    @XmlTransient
    private MessageIdRepository messageIdRepository;

    public IdempotentConsumerType() {
    }

    public IdempotentConsumerType(Expression messageIdExpression, MessageIdRepository messageIdRepository) {
        super(messageIdExpression);
        this.messageIdRepository = messageIdRepository;
    }

    public String toString() {
        return "IdempotentConsumer[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    public String getShortName() {
        return "idempotentConsumer";
    }

    public String getMessageIdRepositoryRef() {
        return this.messageIdRepositoryRef;
    }

    public void setMessageIdRepositoryRef(String messageIdRepositoryRef) {
        this.messageIdRepositoryRef = messageIdRepositoryRef;
    }

    public MessageIdRepository getMessageIdRepository() {
        return this.messageIdRepository;
    }

    public void setMessageIdRepository(MessageIdRepository messageIdRepository) {
        this.messageIdRepository = messageIdRepository;
    }

    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = routeContext.createProcessor(this);
        MessageIdRepository messageIdRepository = this.resolveMessageIdRepository(routeContext);
        return new IdempotentConsumer(this.getExpression().createExpression(routeContext), messageIdRepository, childProcessor);
    }

    public MessageIdRepository resolveMessageIdRepository(RouteContext routeContext) {
        if (this.messageIdRepository == null) {
            this.messageIdRepository = routeContext.lookup(this.messageIdRepositoryRef, MessageIdRepository.class);
        }
        return this.messageIdRepository;
    }
}

