/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.ChoiceType;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.model.InterceptType;
import org.apache.camel.model.InterceptorRef;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.model.OptionalIdentifiedType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.ServiceActivationType;
import org.apache.camel.processor.DelegateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="routes")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoutesType
extends OptionalIdentifiedType<RoutesType>
implements RouteContainer {
    @XmlAttribute
    private Boolean inheritErrorHandlerFlag;
    @XmlElementRef
    private List<RouteType> routes = new ArrayList<RouteType>();
    @XmlElementRef
    private List<ServiceActivationType> activations = new ArrayList<ServiceActivationType>();
    @XmlTransient
    private List<InterceptorType> interceptors = new ArrayList<InterceptorType>();
    @XmlTransient
    private List<InterceptType> intercepts = new ArrayList<InterceptType>();
    @XmlTransient
    private List<ExceptionType> exceptions = new ArrayList<ExceptionType>();
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private ErrorHandlerBuilder errorHandlerBuilder;

    public String toString() {
        return "Routes: " + this.routes;
    }

    @Override
    public List<RouteType> getRoutes() {
        return this.routes;
    }

    @Override
    public void setRoutes(List<RouteType> routes) {
        this.routes = routes;
    }

    public List<InterceptorType> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<InterceptorType> interceptors) {
        this.interceptors = interceptors;
    }

    public List<InterceptType> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptType> intercepts) {
        this.intercepts = intercepts;
    }

    public List<ExceptionType> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<ExceptionType> exceptions) {
        this.exceptions = exceptions;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isInheritErrorHandler() {
        return ProcessorType.isInheritErrorHandler(this.getInheritErrorHandlerFlag());
    }

    public Boolean getInheritErrorHandlerFlag() {
        return this.inheritErrorHandlerFlag;
    }

    public void setInheritErrorHandlerFlag(Boolean inheritErrorHandlerFlag) {
        this.inheritErrorHandlerFlag = inheritErrorHandlerFlag;
    }

    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        return this.errorHandlerBuilder;
    }

    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    public RouteType route() {
        RouteType route = this.createRoute();
        return this.route(route);
    }

    public RouteType from(String uri) {
        RouteType route = this.createRoute();
        route.from(uri);
        return this.route(route);
    }

    public RouteType from(Endpoint endpoint) {
        RouteType route = this.createRoute();
        route.from(endpoint);
        return this.route(route);
    }

    public RouteType route(RouteType route) {
        route.setCamelContext(this.getCamelContext());
        route.setInheritErrorHandlerFlag(this.getInheritErrorHandlerFlag());
        List<InterceptorType> list = this.getInterceptors();
        for (InterceptorType interceptorType : list) {
            route.addInterceptor(interceptorType);
        }
        List<InterceptType> intercepts = this.getIntercepts();
        for (InterceptType intercept : intercepts) {
            InterceptType proxy = intercept.createProxy();
            route.addOutput(proxy);
            route.pushBlock(proxy.getProceed());
        }
        route.getOutputs().addAll(this.getExceptions());
        this.getRoutes().add(route);
        return route;
    }

    public RoutesType intercept(DelegateProcessor interceptor) {
        this.getInterceptors().add(new InterceptorRef(interceptor));
        return this;
    }

    public InterceptType intercept() {
        InterceptType answer = new InterceptType();
        this.getIntercepts().add(answer);
        return answer;
    }

    public ChoiceType intercept(Predicate predicate) {
        InterceptType answer = new InterceptType();
        this.getIntercepts().add(answer);
        return answer.when(predicate);
    }

    public ExceptionType exception(Class exceptionType) {
        ExceptionType answer = new ExceptionType(exceptionType);
        this.getExceptions().add(answer);
        return answer;
    }

    protected RouteType createRoute() {
        RouteType route = new RouteType();
        ErrorHandlerBuilder handler = this.getErrorHandlerBuilder();
        if (this.isInheritErrorHandler() && handler != null) {
            route.setErrorHandlerBuilderIfNull(handler);
        }
        return route;
    }
}

