/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.spi.RouteContext;

@XmlRootElement(name="setProperty")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SetPropertyType
extends ExpressionNode {
    @XmlAttribute
    private String propertyName;

    public SetPropertyType() {
    }

    public SetPropertyType(String propertyName, ExpressionType expression) {
        super(expression);
        this.setPropertyName(propertyName);
    }

    public SetPropertyType(String propertyName, Expression expression) {
        super(expression);
        this.setPropertyName(propertyName);
    }

    public SetPropertyType(String propertyName, String value) {
        super(ExpressionBuilder.constantExpression(value));
        this.setPropertyName(propertyName);
    }

    public String toString() {
        return "SetProperty[" + this.getPropertyName() + ", " + this.getExpression() + "]";
    }

    public String getShortName() {
        return "setProperty";
    }

    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Expression expr = this.getExpression().createExpression(routeContext);
        return ProcessorBuilder.setProperty(this.getPropertyName(), expr);
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

