/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.processor.BatchProcessor;
import org.apache.camel.processor.aggregate.AggregationCollection;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.DefaultAggregationCollection;
import org.apache.camel.processor.aggregate.PredicateAggregationCollection;

public class Aggregator
extends BatchProcessor {
    private Predicate aggregationCompletedPredicate;

    public Aggregator(Endpoint endpoint, Processor processor, Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        this(endpoint, processor, new DefaultAggregationCollection(correlationExpression, aggregationStrategy));
    }

    public Aggregator(Endpoint endpoint, Processor processor, Expression correlationExpression, AggregationStrategy aggregationStrategy, Predicate aggregationCompletedPredicate) {
        this(endpoint, processor, new PredicateAggregationCollection(correlationExpression, aggregationStrategy, aggregationCompletedPredicate));
        this.aggregationCompletedPredicate = aggregationCompletedPredicate;
    }

    public Aggregator(Endpoint endpoint, Processor processor, AggregationCollection collection) {
        super(endpoint, processor, collection);
    }

    public String toString() {
        return "Aggregator[to: " + this.getProcessor() + "]";
    }

    protected boolean isBatchCompleted(int index) {
        if (this.aggregationCompletedPredicate != null && this.getCollection().size() > 0) {
            return true;
        }
        return super.isBatchCompleted(index);
    }
}

