/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.exceptionpolicy;

import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExceptionPolicyStrategy
implements ExceptionPolicyStrategy {
    private static final transient Log LOG = LogFactory.getLog(DefaultExceptionPolicyStrategy.class);

    @Override
    public ExceptionType getExceptionPolicy(Map<Class, ExceptionType> exceptionPolicices, Exchange exchange, Throwable exception) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finding best suited exception policy for thrown exception " + exception.getClass().getName()));
        }
        int targetLevel = DefaultExceptionPolicyStrategy.getInheritanceLevel(exception.getClass());
        ExceptionType candidate = null;
        int candidateDiff = Integer.MAX_VALUE;
        Set<Map.Entry<Class, ExceptionType>> entries = exceptionPolicices.entrySet();
        for (Map.Entry<Class, ExceptionType> entry : entries) {
            Class clazz = entry.getKey();
            ExceptionType type = entry.getValue();
            if (!clazz.isInstance(exception)) continue;
            if (clazz.equals(exception.getClass())) {
                candidate = type;
                break;
            }
            int level = DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz);
            int diff = targetLevel - level;
            if (diff >= candidateDiff) continue;
            candidate = type;
            candidateDiff = diff;
        }
        if (LOG.isDebugEnabled()) {
            if (candidate != null) {
                LOG.debug((Object)("Using " + candidate + " as the exception policy"));
            } else {
                LOG.debug((Object)"No candidate found to be used as exception policy");
            }
        }
        return candidate;
    }

    private static int getInheritanceLevel(Class clazz) {
        if (clazz == null || "java.lang.Object".equals(clazz.getName())) {
            return 0;
        }
        return 1 + DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz.getSuperclass());
    }
}

