/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.InterceptorRef;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.interceptor.ExchangeFormatter;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.commons.logging.LogFactory;

public class TraceInterceptor
extends DelegateProcessor
implements ExchangeFormatter {
    private Logger logger;
    private final ProcessorType node;
    private final Tracer tracer;
    private TraceFormatter formatter;

    public TraceInterceptor(ProcessorType node, Processor target, TraceFormatter formatter, Tracer tracer) {
        super(target);
        this.tracer = tracer;
        this.node = node;
        this.formatter = formatter;
        this.logger = tracer.getLogName() != null ? new Logger(LogFactory.getLog((String)tracer.getLogName()), this) : new Logger(LogFactory.getLog(TraceInterceptor.class), this);
        if (tracer.getLogLevel() != null) {
            this.logger.setLevel(tracer.getLogLevel());
        }
        if (tracer.getFormatter() != null) {
            this.formatter = tracer.getFormatter();
        }
    }

    public TraceInterceptor(ProcessorType node, Processor target, TraceFormatter formatter) {
        this(node, target, formatter, new Tracer());
    }

    public TraceInterceptor(ProcessorType node, Processor target, Tracer tracer) {
        this(node, target, null, tracer);
    }

    public String toString() {
        return "TraceInterceptor[" + this.node + "]";
    }

    public void process(Exchange exchange) throws Exception {
        try {
            if (this.shouldLogNode(this.node) && this.shouldLogExchange(exchange)) {
                this.logExchange(exchange);
            }
            super.proceed(exchange);
        }
        catch (Exception e) {
            if (this.shouldLogException(exchange)) {
                this.logException(exchange, e);
            }
            throw e;
        }
    }

    public Object format(Exchange exchange) {
        return this.formatter.format(this, exchange);
    }

    public ProcessorType getNode() {
        return this.node;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public TraceFormatter getFormatter() {
        return this.formatter;
    }

    protected void logExchange(Exchange exchange) {
        this.logger.process(exchange);
    }

    protected void logException(Exchange exchange, Throwable throwable) {
        if (this.tracer.isTraceExceptions()) {
            this.logger.process(exchange, throwable);
        }
    }

    protected boolean shouldLogExchange(Exchange exchange) {
        return !(this.tracer != null && !this.tracer.isEnabled() || this.tracer.getTraceFilter() != null && !this.tracer.getTraceFilter().matches(exchange));
    }

    protected boolean shouldLogException(Exchange exchange) {
        return this.tracer.isTraceExceptions();
    }

    protected boolean shouldLogNode(ProcessorType node) {
        if (node == null) {
            return false;
        }
        return this.tracer.isTraceInterceptors() || !(node instanceof InterceptStrategy) && !(node instanceof InterceptorRef);
    }
}

