/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.util.ObjectHelper;

public abstract class BinaryPredicateSupport
implements Predicate {
    private final Expression left;
    private final Expression right;

    protected BinaryPredicateSupport(Expression left, Expression right) {
        ObjectHelper.notNull(left, "left");
        ObjectHelper.notNull(right, "right");
        this.left = left;
        this.right = right;
    }

    public String toString() {
        return this.left + " " + this.getOperationText() + " " + this.right;
    }

    public boolean matches(Exchange exchange) {
        Object leftValue = this.left.evaluate(exchange, Object.class);
        Object rightValue = this.right.evaluate(exchange, Object.class);
        return this.matches(exchange, leftValue, rightValue);
    }

    public void assertMatches(String text, Exchange exchange) {
        Object rightValue;
        Object leftValue = this.left.evaluate(exchange, Object.class);
        if (!this.matches(exchange, leftValue, rightValue = this.right.evaluate(exchange, Object.class))) {
            throw new AssertionError((Object)(text + this.assertionFailureMessage(exchange, leftValue, rightValue)));
        }
    }

    protected abstract boolean matches(Exchange var1, Object var2, Object var3);

    protected abstract String getOperationText();

    protected String assertionFailureMessage(Exchange exchange, Object leftValue, Object rightValue) {
        return this + " failed on " + exchange + " with left value <" + leftValue + "> right value <" + rightValue + ">";
    }
}

