/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Producer;
import org.apache.camel.impl.ExpressionAdapter;
import org.apache.camel.language.bean.BeanLanguage;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpressionBuilder {
    private ExpressionBuilder() {
    }

    public static Expression headerExpression(final String headerName) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Object header = exchange.getIn().getHeader(headerName);
                if (header == null) {
                    header = exchange.getProperty(headerName);
                }
                return header;
            }

            public String toString() {
                return "header(" + headerName + ")";
            }
        };
    }

    public static Expression headersExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeaders();
            }

            public String toString() {
                return "headers";
            }
        };
    }

    public static Expression outHeaderExpression(final String headerName) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                if (!exchange.hasOut()) {
                    return null;
                }
                Message out = exchange.getOut();
                Object header = out.getHeader(headerName);
                if (header == null) {
                    header = exchange.getProperty(headerName);
                }
                return header;
            }

            public String toString() {
                return "outHeader(" + headerName + ")";
            }
        };
    }

    public static Expression outHeadersExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getOut().getHeaders();
            }

            public String toString() {
                return "outHeaders";
            }
        };
    }

    public static Expression exchangeExceptionExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                return exception;
            }

            public String toString() {
                return "exchangeException";
            }
        };
    }

    public static Expression exchangeExceptionExpression(final Class<Exception> type) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Exception exception = (Exception)exchange.getException(type);
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                    Iterator<Throwable> it = ObjectHelper.createExceptionIterator(exception);
                    while (it.hasNext()) {
                        Throwable e = it.next();
                        if (!type.isInstance(e)) continue;
                        return type.cast(e);
                    }
                    return null;
                }
                return exception;
            }

            public String toString() {
                return "exchangeException[" + type + "]";
            }
        };
    }

    public static Expression typeConverterExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getTypeConverter();
            }

            public String toString() {
                return "typeConverter";
            }
        };
    }

    public static Expression registryExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getRegistry();
            }

            public String toString() {
                return "registry";
            }
        };
    }

    public static Expression camelContextExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getContext();
            }

            public String toString() {
                return "camelContext";
            }
        };
    }

    public static Expression exchangeExceptionMessageExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                return exception != null ? exception.getMessage() : null;
            }

            public String toString() {
                return "exchangeExceptionMessage";
            }
        };
    }

    public static Expression propertyExpression(final String propertyName) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getProperty(propertyName);
            }

            public String toString() {
                return "property(" + propertyName + ")";
            }
        };
    }

    public static Expression propertiesExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getProperties();
            }

            public String toString() {
                return "properties";
            }
        };
    }

    public static Expression camelContextPropertiesExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getProperties();
            }

            public String toString() {
                return "camelContextProperties";
            }
        };
    }

    public static Expression camelContextPropertyExpression(final String propertyName) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getProperties().get(propertyName);
            }

            public String toString() {
                return "camelContextProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression systemPropertyExpression(String propertyName) {
        return ExpressionBuilder.systemPropertyExpression(propertyName, null);
    }

    public static Expression systemPropertyExpression(final String propertyName, final String defaultValue) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return System.getProperty(propertyName, defaultValue);
            }

            public String toString() {
                return "systemProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression constantExpression(final Object value) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return value;
            }

            public String toString() {
                return "" + value;
            }
        };
    }

    public static Expression bodyExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody();
            }

            public String toString() {
                return "body";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody(type);
            }

            public String toString() {
                return "bodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression bodyTypeExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody().getClass();
            }

            public String toString() {
                return "bodyType";
            }
        };
    }

    public static Expression outBodyExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                if (exchange.hasOut()) {
                    return exchange.getOut().getBody();
                }
                return null;
            }

            public String toString() {
                return "outBody";
            }
        };
    }

    public static <T> Expression outBodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                if (exchange.hasOut()) {
                    return exchange.getOut().getBody(type);
                }
                return null;
            }

            public String toString() {
                return "outBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression faultBodyExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getOut().isFault() ? exchange.getOut().getBody() : null;
            }

            public String toString() {
                return "faultBody";
            }
        };
    }

    public static <T> Expression faultBodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getOut().isFault() ? exchange.getOut().getBody(type) : null;
            }

            public String toString() {
                return "faultBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression exchangeExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange;
            }

            public String toString() {
                return "exchange";
            }
        };
    }

    public static Expression inMessageExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn();
            }

            public String toString() {
                return "inMessage";
            }
        };
    }

    public static Expression outMessageExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getOut();
            }

            public String toString() {
                return "outMessage";
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Class type) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return expression.evaluate(exchange, type);
            }

            public String toString() {
                return "" + expression + ".convertTo(" + type.getCanonicalName() + ".class)";
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Expression type) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return expression.evaluate(exchange, type.evaluate(exchange, Object.class).getClass());
            }

            public String toString() {
                return "" + expression + ".convertToEvaluatedType(" + type + ")";
            }
        };
    }

    public static Expression tokenizeExpression(final Expression expression, final String token) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                Scanner scanner = ObjectHelper.getScanner(exchange, value);
                scanner.useDelimiter(token);
                return scanner;
            }

            public String toString() {
                return "tokenize(" + expression + ", " + token + ")";
            }
        };
    }

    public static Expression regexTokenizeExpression(final Expression expression, final String regexTokenizer) {
        final Pattern pattern = Pattern.compile(regexTokenizer);
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                Scanner scanner = ObjectHelper.getScanner(exchange, value);
                scanner.useDelimiter(regexTokenizer);
                return scanner;
            }

            public String toString() {
                return "regexTokenize(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression sortExpression(final Expression expression, final Comparator comparator) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                List list = expression.evaluate(exchange, List.class);
                Collections.sort(list, comparator);
                return list;
            }

            public String toString() {
                return "sort(" + expression + " by: " + comparator + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final String replacement) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                if (text == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final Expression replacementExpression) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                String replacement = replacementExpression.evaluate(exchange, String.class);
                if (text == null || replacement == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression append(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return left.evaluate(exchange, String.class) + right.evaluate(exchange, String.class);
            }

            public String toString() {
                return "append(" + left + ", " + right + ")";
            }
        };
    }

    public static Expression prepend(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return right.evaluate(exchange, String.class) + left.evaluate(exchange, String.class);
            }

            public String toString() {
                return "prepend(" + left + ", " + right + ")";
            }
        };
    }

    public static Expression concatExpression(Collection<Expression> expressions) {
        return ExpressionBuilder.concatExpression(expressions, null);
    }

    public static Expression concatExpression(final Collection<Expression> expressions, final String expression) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                StringBuffer buffer = new StringBuffer();
                for (Expression expression2 : expressions) {
                    String text = expression2.evaluate(exchange, String.class);
                    if (text == null) continue;
                    buffer.append(text);
                }
                return buffer.toString();
            }

            public String toString() {
                if (expression != null) {
                    return expression;
                }
                return "concat" + expressions;
            }
        };
    }

    public static Expression messageIdExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getMessageId();
            }

            public String toString() {
                return "messageId";
            }
        };
    }

    public static Expression dateExpression(final String command, final String pattern) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String key;
                Date date;
                if ("now".equals(command)) {
                    date = new Date();
                } else if (command.startsWith("header.") || command.startsWith("in.header.")) {
                    key = command.substring(command.lastIndexOf(46) + 1);
                    date = exchange.getIn().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Cannot find java.util.Date object at " + command);
                    }
                } else if (command.startsWith("out.header.")) {
                    key = command.substring(command.lastIndexOf(46) + 1);
                    date = exchange.getOut().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Cannot find java.util.Date object at " + command);
                    }
                } else {
                    throw new IllegalArgumentException("Command not supported for dateExpression: " + command);
                }
                SimpleDateFormat df = new SimpleDateFormat(pattern);
                return df.format(date);
            }

            public String toString() {
                return "date(" + command + ":" + pattern + ")";
            }
        };
    }

    public static Expression simpleExpression(final String expression) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Language language = exchange.getContext().resolveLanguage("simple");
                return language.createExpression(expression).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "simple(" + expression + ")";
            }
        };
    }

    public static Expression beanExpression(final String expression) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Language language = exchange.getContext().resolveLanguage("bean");
                return language.createExpression(expression).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "bean(" + expression + ")";
            }
        };
    }

    public static Expression beanExpression(Class beanType, String methodName) {
        return BeanLanguage.bean(beanType, methodName);
    }

    public static Expression beanExpression(String beanRef, String methodName) {
        String expression = methodName != null ? beanRef + "." + methodName : beanRef;
        return ExpressionBuilder.beanExpression(expression);
    }

    public static Expression toExpression(final String uri) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Endpoint endpoint = exchange.getContext().getEndpoint(uri);
                if (endpoint == null) {
                    throw new NoSuchEndpointException(uri);
                }
                try {
                    Producer producer = endpoint.createProducer();
                    producer.start();
                    producer.process(exchange);
                    producer.stop();
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
                if (ExchangeHelper.isOutCapable(exchange)) {
                    return exchange.getOut().getBody();
                }
                return exchange.getIn().getBody();
            }

            public String toString() {
                return "to(" + uri + ")";
            }
        };
    }
}

