/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileOperations;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEndpoint
extends GenericFileEndpoint<File> {
    private FileOperations operations = new FileOperations(this);
    private File file;

    public FileEndpoint() {
        this.readLock = "markerFile";
    }

    public FileEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.readLock = "markerFile";
    }

    @Override
    public FileConsumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull(this.operations, "operations");
        ObjectHelper.notNull(this.file, "file");
        if (this.file.getName().contains(".")) {
            throw new IllegalArgumentException("Only directory is supported. Endpoint must be configured with a valid starting directory: " + this.file);
        }
        if (!this.file.exists() && !this.file.isDirectory() && this.isAutoCreate()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating non existing starting directory: " + this.file));
            }
            boolean absolute = this.file.isAbsolute();
            this.operations.buildDirectory(this.file.getPath(), absolute);
        }
        FileConsumer result = new FileConsumer(this, processor, this.operations);
        if (this.isDelete() && this.getMove() != null) {
            throw new IllegalArgumentException("You cannot set both delete=true and move options");
        }
        if (this.isNoop() && !this.isIdempotent()) {
            this.log.info((Object)"Endpoint is configured with noop=true so forcing endpoint to be idempotent as well");
            this.setIdempotent(true);
        }
        if (this.isIdempotent() && this.idempotentRepository == null) {
            this.log.info((Object)"Using default memory based idempotent repository with cache max size: 1000");
            this.idempotentRepository = MemoryIdempotentRepository.memoryIdempotentRepository(1000);
        }
        result.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        this.configureConsumer(result);
        return result;
    }

    @Override
    public GenericFileProducer<File> createProducer() throws Exception {
        ObjectHelper.notNull(this.operations, "operations");
        return new GenericFileProducer<File>(this, this.operations);
    }

    @Override
    public Exchange createExchange(GenericFile<File> file) {
        DefaultExchange exchange = new DefaultExchange(this);
        if (file != null) {
            file.bindToExchange(exchange);
        }
        return exchange;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.getConfiguration().setDirectory(file.getPath());
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    protected String createEndpointUri() {
        return "file://" + this.getFile().getAbsolutePath();
    }

    @Override
    public char getFileSeparator() {
        return File.separatorChar;
    }

    @Override
    public boolean isAbsolute(String name) {
        File file = new File(name);
        return file.isAbsolute();
    }
}

