/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Date;
import java.util.Timer;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.timer.TimerComponent;
import org.apache.camel.component.timer.TimerConsumer;
import org.apache.camel.impl.DefaultEndpoint;

public class TimerEndpoint
extends DefaultEndpoint {
    private String timerName;
    private Date time;
    private long period = 1000L;
    private long delay;
    private boolean fixedRate;
    private boolean daemon = true;
    private Timer timer;

    public TimerEndpoint() {
    }

    public TimerEndpoint(String fullURI, TimerComponent component, String timerName) {
        super(fullURI, component);
        this.timer = component.getTimer(this);
        this.timerName = timerName;
    }

    public TimerEndpoint(String endpointUri, Timer timer) {
        this(endpointUri);
        this.timer = timer;
    }

    public TimerEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Producer createProducer() throws Exception {
        throw new RuntimeCamelException("Cannot produce to a TimerEndpoint: " + this.getEndpointUri());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new TimerConsumer(this, processor);
    }

    public String getTimerName() {
        if (this.timerName == null) {
            this.timerName = this.getEndpointUri();
        }
        return this.timerName;
    }

    public void setTimerName(String timerName) {
        this.timerName = timerName;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public boolean isSingleton() {
        return true;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }
}

