/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Channel;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultRoute
implements Route {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private Endpoint endpoint;
    private List<Service> services = new ArrayList<Service>();
    private List<Channel> channels = new ArrayList<Channel>();

    public DefaultRoute(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public DefaultRoute(Endpoint endpoint, Service ... services) {
        this(endpoint);
        for (Service service : services) {
            this.addService(service);
        }
    }

    public String toString() {
        return "Route";
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public List<Service> getServicesForRoute() throws Exception {
        ArrayList<Service> servicesForRoute = new ArrayList<Service>(this.getServices());
        this.addServices(servicesForRoute);
        return servicesForRoute;
    }

    @Override
    public List<Service> getServices() {
        return this.services;
    }

    @Override
    public void setServices(List<Service> services) {
        this.services = services;
    }

    @Override
    public void addService(Service service) {
        this.getServices().add(service);
    }

    protected void addServices(List<Service> services) throws Exception {
    }
}

