/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RouteNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Traceable;

public class DefaultRouteNode
implements RouteNode {
    private Expression expression;
    private Processor processor;
    private ProcessorDefinition processorDefinition;

    public DefaultRouteNode(ProcessorDefinition processorDefinition, Processor processor) {
        this.processor = processor;
        this.processorDefinition = processorDefinition;
    }

    public DefaultRouteNode(ProcessorDefinition processorDefinition, Expression expression) {
        this.processorDefinition = processorDefinition;
        this.expression = expression;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public ProcessorDefinition getProcessorDefinition() {
        return this.processorDefinition;
    }

    public String getLabel(Exchange exchange) {
        if (this.expression != null) {
            return this.expression.evaluate(exchange, String.class);
        }
        if (this.processor != null) {
            if (this.processor instanceof Traceable) {
                Traceable trace = (Traceable)((Object)this.processor);
                return trace.getTraceLabel();
            }
            this.processor.toString();
        }
        return this.processorDefinition.getLabel();
    }

    public boolean isAbstract() {
        return this.processor == null;
    }

    public String toString() {
        return "RouteNode[" + this.processorDefinition + "]";
    }
}

