/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultServicePool<Key, Service>
extends ServiceSupport
implements ServicePool<Key, Service> {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final ConcurrentHashMap<Key, BlockingQueue<Service>> pool = new ConcurrentHashMap();
    protected final int capacity;

    public DefaultServicePool(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public synchronized Service addAndAcquire(Key key, Service service) {
        BlockingQueue<Service> entry = this.pool.get(key);
        if (entry == null) {
            entry = new ArrayBlockingQueue<Service>(this.capacity);
            this.pool.put(key, entry);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("AddAndAcquire key: " + key + " service: " + service));
        }
        if (entry.size() >= this.capacity) {
            throw new IllegalStateException("Queue full");
        }
        return service;
    }

    @Override
    public synchronized Service acquire(Key key) {
        BlockingQueue<Service> services = this.pool.get(key);
        if (services == null || services.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("No free services in pool to acquire for key: " + key));
            }
            return null;
        }
        Object answer = services.poll();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Acquire: " + key + " service: " + answer));
        }
        return (Service)answer;
    }

    @Override
    public synchronized void release(Key key, Service service) {
        BlockingQueue<Service> services;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Release: " + key + " service: " + service));
        }
        if ((services = this.pool.get(key)) != null) {
            services.add(service);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.log.debug((Object)("Starting service pool: " + this));
    }

    @Override
    protected void doStop() throws Exception {
        this.log.debug((Object)("Stopping service pool: " + this));
        for (BlockingQueue<Service> entry : this.pool.values()) {
            ArrayList values = new ArrayList();
            entry.drainTo(values);
            ServiceHelper.stopServices(values);
            entry.clear();
        }
        this.pool.clear();
    }
}

