/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.UuidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageSupport
implements Message {
    private static final UuidGenerator DEFALT_ID_GENERATOR = new UuidGenerator();
    private Exchange exchange;
    private Object body;
    private String messageId;

    @Override
    public Object getBody() {
        if (this.body == null) {
            this.body = this.createBody();
        }
        return this.body;
    }

    @Override
    public <T> T getBody(Class<T> type) {
        return this.getBody(type, this.getBody());
    }

    @Override
    public Object getMandatoryBody() throws InvalidPayloadException {
        Object answer = this.getBody();
        if (answer == null) {
            throw new InvalidPayloadException(this.getExchange(), Object.class, this);
        }
        return answer;
    }

    protected <T> T getBody(Class<T> type, Object body) {
        if (type.isInstance(body)) {
            return type.cast(body);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            TypeConverter converter = e.getContext().getTypeConverter();
            T answer = converter.convertTo(type, this.getExchange(), body);
            if (answer != null) {
                return answer;
            }
            answer = converter.convertTo(type, this.getExchange(), this);
            if (answer != null) {
                return answer;
            }
        }
        return null;
    }

    @Override
    public <T> T getMandatoryBody(Class<T> type) throws InvalidPayloadException {
        if (type.isInstance(this.body)) {
            return type.cast(this.body);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            TypeConverter converter = e.getContext().getTypeConverter();
            try {
                return converter.mandatoryConvertTo(type, e, this.getBody());
            }
            catch (Exception cause) {
                throw new InvalidPayloadException(e, type, this, cause);
            }
        }
        throw new InvalidPayloadException(e, type, this);
    }

    @Override
    public void setBody(Object body) {
        this.body = body;
    }

    @Override
    public <T> void setBody(Object value, Class<T> type) {
        T v;
        Exchange e = this.getExchange();
        if (e != null && (v = e.getContext().getTypeConverter().convertTo(type, e, value)) != null) {
            value = v;
        }
        this.setBody(value);
    }

    @Override
    public Message copy() {
        Message answer = this.newInstance();
        answer.copyFrom(this);
        return answer;
    }

    @Override
    public void copyFrom(Message that) {
        this.setMessageId(that.getMessageId());
        this.setBody(that.getBody());
        if (that.hasHeaders()) {
            this.getHeaders().putAll(that.getHeaders());
        }
        if (that.hasAttachments()) {
            this.getAttachments().putAll(that.getAttachments());
        }
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public abstract Message newInstance();

    protected Object createBody() {
        return null;
    }

    @Override
    public String getMessageId() {
        if (this.messageId == null) {
            this.messageId = this.createMessageId();
        }
        return this.messageId;
    }

    @Override
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    protected String createMessageId() {
        return DEFALT_ID_GENERATOR.generateId();
    }
}

