/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.language.bean.RuntimeBeanExpressionException;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanExpression
implements Expression,
Predicate {
    private String beanName;
    private String method;
    private Object bean;

    public BeanExpression(Object bean, String method) {
        this.bean = bean;
        this.method = method;
    }

    public BeanExpression(String beanName, String method) {
        this.beanName = beanName;
        this.method = method;
    }

    public String toString() {
        return "BeanExpression[bean:" + (this.bean == null ? this.beanName : this.bean) + " method: " + this.method + "]";
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return "bean: " + this.beanName + " method: " + this.method;
    }

    public Object evaluate(Exchange exchange) {
        BeanHolder holder = this.bean == null ? new RegistryBean(exchange.getContext(), this.beanName) : new ConstantBeanHolder(this.bean, exchange.getContext());
        BeanProcessor processor = new BeanProcessor(holder);
        if (this.method != null) {
            processor.setMethod(this.method);
        }
        try {
            Exchange newExchange = exchange.copy();
            if (!newExchange.getPattern().isOutCapable()) {
                newExchange.setPattern(ExchangePattern.InOut);
            }
            processor.process(newExchange);
            return newExchange.getOut().getBody();
        }
        catch (Exception e) {
            throw new RuntimeBeanExpressionException(exchange, this.beanName, this.method, e);
        }
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        Object result = this.evaluate(exchange);
        return exchange.getContext().getTypeConverter().convertTo(type, result);
    }

    @Override
    public boolean matches(Exchange exchange) {
        Object value = this.evaluate(exchange);
        return ObjectHelper.evaluateValuePredicate(value);
    }

    public void assertMatches(String text, Exchange exchange) throws AssertionError {
    }
}

