/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.Exchange;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstrumentationProcessor
extends DelegateProcessor {
    private static final transient Log LOG = LogFactory.getLog(InstrumentationProcessor.class);
    private PerformanceCounter counter;
    private String type;

    public InstrumentationProcessor() {
    }

    public InstrumentationProcessor(PerformanceCounter counter) {
        this.counter = counter;
    }

    public String toString() {
        return "Instrumention" + (this.type != null ? ":" + this.type : "") + "[" + this.processor + "]";
    }

    public void setCounter(PerformanceCounter counter) {
        this.counter = counter;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.processor != null) {
            long startTime = 0L;
            if (this.counter != null) {
                startTime = System.nanoTime();
            }
            try {
                this.processor.process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            if (this.counter != null) {
                this.recordTime(exchange, (double)(System.nanoTime() - startTime) / 1000000.0);
            }
        }
    }

    protected void recordTime(Exchange exchange, double duration) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Recording duration: " + duration + " millis for exchange: " + exchange));
        }
        if (!exchange.isFailed() && exchange.getException() == null) {
            this.counter.completedExchange(duration);
        } else {
            this.counter.failedExchange();
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

