/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.OnCompletionProcessor;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="onCompletion")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnCompletionDefinition
extends ProcessorDefinition<ProcessorDefinition> {
    @XmlAttribute(required=false)
    private Boolean onCompleteOnly = Boolean.FALSE;
    @XmlAttribute(required=false)
    private Boolean onFailureOnly = Boolean.FALSE;
    @XmlElement(name="onWhen", required=false)
    private WhenDefinition onWhen;
    @XmlElementRef
    private List<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();

    public String toString() {
        return "onCompletion[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "onCompletion";
    }

    @Override
    public String getLabel() {
        return "onCompletion";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createOutputsProcessor(routeContext);
        childProcessor = new UnitOfWorkProcessor(childProcessor);
        Predicate when = null;
        if (this.onWhen != null) {
            when = this.onWhen.getExpression().createPredicate(routeContext);
        }
        if (this.onCompleteOnly.booleanValue() && this.onFailureOnly.booleanValue()) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        return new OnCompletionProcessor(childProcessor, this.onCompleteOnly, this.onFailureOnly, when);
    }

    public void removeAllOnCompletionDefinition(ProcessorDefinition definition) {
        Iterator<ProcessorDefinition> it = definition.getOutputs().iterator();
        while (it.hasNext()) {
            ProcessorDefinition out = it.next();
            if (!(out instanceof OnCompletionDefinition)) continue;
            it.remove();
        }
    }

    @Override
    public ProcessorDefinition<? extends ProcessorDefinition> end() {
        this.getParent().popBlock();
        return super.end();
    }

    public OnCompletionDefinition onCompleteOnly() {
        this.setOnCompleteOnly(Boolean.TRUE);
        this.setOnFailureOnly(Boolean.FALSE);
        return this;
    }

    public OnCompletionDefinition onFailureOnly() {
        this.setOnCompleteOnly(Boolean.FALSE);
        this.setOnFailureOnly(Boolean.TRUE);
        return this;
    }

    public OnCompletionDefinition onWhen(Predicate predicate) {
        this.setOnWhen(new WhenDefinition(predicate));
        return this;
    }

    public ExpressionClause<OnCompletionDefinition> onWhen() {
        this.onWhen = new WhenDefinition();
        ExpressionClause<OnCompletionDefinition> clause = new ExpressionClause<OnCompletionDefinition>(this);
        this.onWhen.setExpression(clause);
        return clause;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition> outputs) {
        this.outputs = outputs;
    }

    public Boolean getOnCompleteOnly() {
        return this.onCompleteOnly;
    }

    public void setOnCompleteOnly(Boolean onCompleteOnly) {
        this.onCompleteOnly = onCompleteOnly;
    }

    public Boolean getOnFailureOnly() {
        return this.onFailureOnly;
    }

    public void setOnFailureOnly(Boolean onFailureOnly) {
        this.onFailureOnly = onFailureOnly;
    }

    public WhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(WhenDefinition onWhen) {
        this.onWhen = onWhen;
    }
}

