/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.WhenDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessorDefinitionHelper {
    private ProcessorDefinitionHelper() {
    }

    public static <T> Iterator<T> filterTypeInOutputs(List<ProcessorDefinition> outputs, Class<T> type) {
        ArrayList found = new ArrayList();
        ProcessorDefinitionHelper.doFindType(outputs, type, found);
        return found.iterator();
    }

    public static <T> T findFirstTypeInOutputs(List<ProcessorDefinition> outputs, Class<T> type) {
        ArrayList found = new ArrayList();
        ProcessorDefinitionHelper.doFindType(outputs, type, found);
        if (found.isEmpty()) {
            return null;
        }
        return (T)found.iterator().next();
    }

    private static void doFindType(List<ProcessorDefinition> outputs, Class<?> type, List found) {
        if (outputs == null || outputs.isEmpty()) {
            return;
        }
        for (ProcessorDefinition out : outputs) {
            List<ProcessorDefinition> children;
            if (type.isInstance(out)) {
                found.add(out);
            }
            if (out instanceof SendDefinition) {
                SendDefinition send = (SendDefinition)out;
                children = send.getOutputs();
                ProcessorDefinitionHelper.doFindType(children, type, found);
            }
            if (out instanceof ChoiceDefinition) {
                ChoiceDefinition choice = (ChoiceDefinition)out;
                for (WhenDefinition when : choice.getWhenClauses()) {
                    List<ProcessorDefinition> children2 = when.getOutputs();
                    ProcessorDefinitionHelper.doFindType(children2, type, found);
                }
                if (choice.getOtherwise() != null) {
                    children = choice.getOtherwise().getOutputs();
                    ProcessorDefinitionHelper.doFindType(children, type, found);
                }
            }
            List<ProcessorDefinition> children3 = out.getOutputs();
            ProcessorDefinitionHelper.doFindType(children3, type, found);
        }
    }
}

