/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.SortProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="sort")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SortDefinition
extends OutputDefinition<SortDefinition> {
    @XmlTransient
    private Comparator comparator;
    @XmlAttribute(required=false)
    private String comparatorRef;
    @XmlElement(name="expression", required=false)
    private ExpressionSubElementDefinition expression;

    public SortDefinition() {
    }

    public SortDefinition(Expression expression) {
        this.setExpression(expression);
    }

    public SortDefinition(Expression expression, Comparator comparator) {
        this(expression);
        this.comparator = comparator;
    }

    public String toString() {
        return "sort[" + this.getExpression() + " by: " + (this.comparatorRef != null ? "ref:" + this.comparatorRef : this.comparator) + "]";
    }

    @Override
    public String getShortName() {
        return "sort";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (ObjectHelper.isNotEmpty(this.comparatorRef)) {
            this.comparator = routeContext.getCamelContext().getRegistry().lookup(this.comparatorRef, Comparator.class);
        }
        if (this.comparator == null) {
            this.comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ObjectHelper.compare(o1, o2);
                }
            };
        }
        if (this.getExpression() == null) {
            this.setExpression(ExpressionBuilder.bodyExpression());
        }
        return new SortProcessor(this.getExpression(), this.getComparator());
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return Collections.EMPTY_LIST;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public String getComparatorRef() {
        return this.comparatorRef;
    }

    public void setComparatorRef(String comparatorRef) {
        this.comparatorRef = comparatorRef;
    }

    public Expression getExpression() {
        if (this.expression == null) {
            return null;
        }
        if (this.expression.getExpression() != null) {
            return this.expression.getExpression();
        }
        return this.expression.getExpressionType();
    }

    public void setExpression(Expression expression) {
        this.expression = new ExpressionSubElementDefinition(expression);
    }

    public SortDefinition comparator(Comparator comparator) {
        this.setComparator(comparator);
        return this;
    }

    public SortDefinition comparatorRef(String ref) {
        this.setComparatorRef(ref);
        return this;
    }
}

