/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.Splitter;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="split")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SplitDefinition
extends ExpressionNode {
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute(required=false)
    private Boolean parallelProcessing;
    @XmlAttribute(required=false)
    private String strategyRef;
    @XmlAttribute(required=false)
    private String executorServiceRef;
    @XmlAttribute(required=false)
    private Boolean streaming = false;

    public SplitDefinition() {
    }

    public SplitDefinition(Expression expression) {
        super(expression);
    }

    public SplitDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    public String toString() {
        return "Split[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "split";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = routeContext.createProcessor(this);
        this.aggregationStrategy = this.createAggregationStrategy(routeContext);
        this.executorService = this.createExecutorService(routeContext);
        return new Splitter(this.getExpression().createExpression(routeContext), childProcessor, this.aggregationStrategy, this.isParallelProcessing(), this.executorService, this.streaming);
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null && this.strategyRef != null) {
            strategy = routeContext.lookup(this.strategyRef, AggregationStrategy.class);
        }
        if (strategy == null) {
            strategy = new UseLatestAggregationStrategy();
        }
        return strategy;
    }

    private ExecutorService createExecutorService(RouteContext routeContext) {
        if (this.executorServiceRef != null) {
            this.executorService = routeContext.lookup(this.executorServiceRef, ExecutorService.class);
        }
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(5);
        }
        return this.executorService;
    }

    public ExpressionClause<SplitDefinition> expression() {
        return ExpressionClause.createAndSetExpression(this);
    }

    public SplitDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public SplitDefinition parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public SplitDefinition parallelProcessing(boolean parallelProcessing) {
        this.setParallelProcessing(parallelProcessing);
        return this;
    }

    public SplitDefinition streaming() {
        this.setStreaming(true);
        return this;
    }

    public SplitDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing != null ? this.parallelProcessing : false;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public boolean isStreaming() {
        return this.streaming != null ? this.streaming : false;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

