/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.processor.BatchProcessor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.aggregate.AggregationCollection;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.DefaultAggregationCollection;
import org.apache.camel.processor.aggregate.PredicateAggregationCollection;

public class Aggregator
extends BatchProcessor
implements Traceable {
    private Expression correlationExpression;

    public Aggregator(Processor processor, Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        this(processor, new DefaultAggregationCollection(correlationExpression, aggregationStrategy));
        this.correlationExpression = correlationExpression;
    }

    public Aggregator(Processor processor, Expression correlationExpression, AggregationStrategy aggregationStrategy, Predicate aggregationCompletedPredicate) {
        this(processor, new PredicateAggregationCollection(correlationExpression, aggregationStrategy, aggregationCompletedPredicate));
        this.correlationExpression = correlationExpression;
    }

    public Aggregator(Processor processor, AggregationCollection collection) {
        super(processor, collection);
    }

    public String toString() {
        return "Aggregator[to: " + this.getProcessor() + "]";
    }

    public String getTraceLabel() {
        return "Aggregate[" + this.correlationExpression + "]";
    }
}

