/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Channel;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChannel
extends ServiceSupport
implements Processor,
Channel {
    private static final transient Log LOG = LogFactory.getLog(DefaultChannel.class);
    private final List<InterceptStrategy> interceptors = new ArrayList<InterceptStrategy>();
    private Processor errorHandler;
    private Processor nextProcessor;
    private Processor output;
    private ProcessorDefinition definition;

    @Override
    public List<Processor> next() {
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.nextProcessor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.nextProcessor != null;
    }

    @Override
    public void setNextProcessor(Processor next) {
        this.nextProcessor = next;
    }

    @Override
    public Processor getOutput() {
        return this.errorHandler != null ? this.errorHandler : this.output;
    }

    @Override
    public void setOutput(Processor output) {
        this.output = output;
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    public boolean hasInterceptorStrategy(Class type) {
        for (InterceptStrategy strategy : this.interceptors) {
            if (!type.isInstance(strategy)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setErrorHandler(Processor errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void addInterceptStrategy(InterceptStrategy strategy) {
        this.interceptors.add(strategy);
    }

    @Override
    public void addInterceptStrategies(List<InterceptStrategy> strategies) {
        this.interceptors.addAll(strategies);
    }

    @Override
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptors;
    }

    @Override
    public ProcessorDefinition getProcessorDefinition() {
        return this.definition;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.errorHandler, this.output);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.output, this.errorHandler);
    }

    @Override
    public void initChannel(ProcessorDefinition outputDefinition, RouteContext routeContext) throws Exception {
        this.definition = outputDefinition;
        Processor target = this.nextProcessor;
        for (InterceptStrategy strategy : this.interceptors) {
            Processor next = target == this.nextProcessor ? null : this.nextProcessor;
            target = strategy.wrapProcessorInInterceptors(routeContext.getCamelContext(), outputDefinition, target, next);
        }
        this.output = target;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Processor processor = this.getOutput();
        if (processor != null && this.continueProcessing(exchange)) {
            processor.process(exchange);
        }
    }

    protected boolean continueProcessing(Exchange exchange) {
        boolean doStop;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop).booleanValue())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Exchange is marked to stop routing: " + exchange));
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "Channel[" + this.nextProcessor + "]";
    }
}

