/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelayProcessorSupport;
import org.apache.camel.processor.Traceable;

public class Delayer
extends DelayProcessorSupport
implements Traceable {
    private final Expression delay;

    public Delayer(Processor processor, Expression delay) {
        super(processor);
        this.delay = delay;
    }

    public String toString() {
        return "Delayer[" + this.delay + " to: " + this.getProcessor() + "]";
    }

    public String getTraceLabel() {
        return "Delayer[" + this.delay + "]";
    }

    protected void delay(Exchange exchange) throws Exception {
        Long longValue;
        long time = 0L;
        if (this.delay != null && (longValue = this.delay.evaluate(exchange, Long.class)) != null) {
            time = longValue;
        }
        if (time <= 0L) {
            return;
        }
        this.waitUntil(time += this.defaultProcessTime(exchange), exchange);
    }

    protected long defaultProcessTime(Exchange exchange) {
        return this.currentSystemTime();
    }
}

