/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.exceptionpolicy;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyKey;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExceptionPolicyStrategy
implements ExceptionPolicyStrategy {
    private static final transient Log LOG = LogFactory.getLog(DefaultExceptionPolicyStrategy.class);

    @Override
    public OnExceptionDefinition getExceptionPolicy(Map<ExceptionPolicyKey, OnExceptionDefinition> exceptionPolicices, Exchange exchange, Throwable exception) {
        Iterator<Throwable> it = this.createExceptionIterator(exception);
        while (it.hasNext()) {
            OnExceptionDefinition type = this.findMatchedExceptionPolicy(exceptionPolicices, exchange, it.next());
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private OnExceptionDefinition findMatchedExceptionPolicy(Map<ExceptionPolicyKey, OnExceptionDefinition> exceptionPolicices, Exchange exchange, Throwable exception) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Finding best suited exception policy for thrown exception " + exception.getClass().getName()));
        }
        int targetLevel = DefaultExceptionPolicyStrategy.getInheritanceLevel(exception.getClass());
        OnExceptionDefinition candidate = null;
        int candidateDiff = Integer.MAX_VALUE;
        Set<Map.Entry<ExceptionPolicyKey, OnExceptionDefinition>> entries = exceptionPolicices.entrySet();
        for (Map.Entry<ExceptionPolicyKey, OnExceptionDefinition> entry : entries) {
            Class clazz = entry.getKey().getExceptionClass();
            OnExceptionDefinition type = entry.getValue();
            if (!this.filter(type, clazz, exception)) continue;
            if (!this.matchesWhen(type, exchange)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("The type did not match when: " + type));
                continue;
            }
            if (clazz.equals(exception.getClass())) {
                candidate = type;
                break;
            }
            int level = DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz);
            int diff = targetLevel - level;
            if (diff >= candidateDiff) continue;
            candidate = type;
            candidateDiff = diff;
        }
        if (LOG.isTraceEnabled()) {
            if (candidate != null) {
                LOG.trace((Object)("Using " + candidate + " as the exception policy"));
            } else {
                LOG.trace((Object)"No candidate found to be used as exception policy");
            }
        }
        return candidate;
    }

    protected boolean filter(OnExceptionDefinition type, Class exceptionClass, Throwable exception) {
        return exceptionClass.isInstance(exception);
    }

    protected boolean matchesWhen(OnExceptionDefinition definition, Exchange exchange) {
        if (definition.getOnWhen() == null || definition.getOnWhen().getExpression() == null) {
            return true;
        }
        return definition.getOnWhen().getExpression().matches(exchange);
    }

    protected Iterator<Throwable> createExceptionIterator(Throwable exception) {
        return ObjectHelper.createExceptionIterator(exception);
    }

    private static int getInheritanceLevel(Class clazz) {
        if (clazz == null || "java.lang.Object".equals(clazz.getName())) {
            return 0;
        }
        return 1 + DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz.getSuperclass());
    }
}

