/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.DelayInterceptor;
import org.apache.camel.spi.InterceptStrategy;

public class Delayer
implements InterceptStrategy {
    private boolean enabled = true;
    private long delay;

    public Delayer() {
    }

    public Delayer(long delay) {
        this.delay = delay;
    }

    public static Delayer getDelayer(CamelContext context) {
        List<InterceptStrategy> list = context.getInterceptStrategies();
        for (InterceptStrategy interceptStrategy : list) {
            if (!(interceptStrategy instanceof Delayer)) continue;
            return (Delayer)interceptStrategy;
        }
        return null;
    }

    public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition definition, Processor target, Processor nextTarget) throws Exception {
        return new DelayInterceptor(definition, target, this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public String toString() {
        return "Delayer[" + this.delay + "]";
    }
}

