/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validation;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.ValidationException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaValidationException
extends ValidationException {
    private final Object schema;
    private final List<SAXParseException> fatalErrors;
    private final List<SAXParseException> errors;
    private final List<SAXParseException> warnings;

    public SchemaValidationException(Exchange exchange, Object schema, List<SAXParseException> fatalErrors, List<SAXParseException> errors, List<SAXParseException> warnings) {
        super(exchange, SchemaValidationException.message(schema, fatalErrors, errors, warnings));
        this.schema = schema;
        this.fatalErrors = fatalErrors;
        this.errors = errors;
        this.warnings = warnings;
    }

    public Object getSchema() {
        return this.schema;
    }

    public List<SAXParseException> getErrors() {
        return this.errors;
    }

    public List<SAXParseException> getFatalErrors() {
        return this.fatalErrors;
    }

    public List<SAXParseException> getWarnings() {
        return this.warnings;
    }

    protected static String message(Object schema, List<SAXParseException> fatalErrors, List<SAXParseException> errors, List<SAXParseException> warnings) {
        StringBuffer buffer = new StringBuffer("Validation failed for: ");
        buffer.append(schema);
        if (!fatalErrors.isEmpty()) {
            buffer.append(" fatal errors: ");
            buffer.append(fatalErrors);
        }
        if (!errors.isEmpty()) {
            buffer.append(" errors: ");
            buffer.append(errors);
        }
        return buffer.toString();
    }
}

