/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.Stack;

public final class FileUtil {
    private static final int RETRY_SLEEP_MILLIS = 10;
    private static File defaultTempDir;

    private FileUtil() {
    }

    public static String normalizePath(String path) {
        if (path != null && System.getProperty("os.name").startsWith("Windows") && path.indexOf(47) >= 0) {
            return path.replace('/', '\\');
        }
        return path;
    }

    public static void mkDir(File dir) {
        boolean result;
        if (dir == null) {
            throw new IllegalArgumentException("dir attribute is required");
        }
        if (dir.isFile()) {
            throw new RuntimeException("Unable to create directory as a file already exists with that name: " + dir.getAbsolutePath());
        }
        if (!dir.exists() && !(result = FileUtil.doMkDirs(dir))) {
            String msg = "Directory " + dir.getAbsolutePath() + " creation was not successful for an unknown reason";
            throw new RuntimeException(msg);
        }
    }

    private static boolean doMkDirs(File f) {
        if (!f.mkdirs()) {
            try {
                Thread.sleep(10L);
                return f.mkdirs();
            }
            catch (InterruptedException ex) {
                return f.mkdirs();
            }
        }
        return true;
    }

    public static void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (String s : list) {
            File f = new File(d, s);
            if (f.isDirectory()) {
                FileUtil.removeDir(f);
                continue;
            }
            FileUtil.delete(f);
        }
        FileUtil.delete(d);
    }

    public static void delete(File f) {
        if (!f.delete()) {
            if (FileUtil.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtil.createTempFile(prefix, suffix, null);
    }

    public static File createTempFile(String prefix, String suffix, File parentDir) throws IOException {
        File parent;
        File file = parent = parentDir == null ? FileUtil.getDefaultTempDir() : parentDir;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "camel";
        } else if (prefix.length() < 3) {
            prefix = prefix + "camel";
        }
        parent.mkdirs();
        return File.createTempFile(prefix, suffix, parent);
    }

    public static String stripLeadingSeparator(String name) {
        if (name == null) {
            return null;
        }
        while (name.startsWith("/") || name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        return name;
    }

    public static String stripTrailingSeparator(String name) {
        if (name == null) {
            return null;
        }
        while (name.endsWith("/") || name.endsWith(File.separator)) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static String stripPath(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(47);
        if (pos == -1) {
            pos = name.lastIndexOf(File.separator);
        }
        if (pos != -1) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static String stripExt(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return name;
    }

    public static String onlyPath(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(47);
        if (pos == -1) {
            pos = name.lastIndexOf(File.separator);
        }
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return null;
    }

    public static String compactPath(String path) {
        String[] parts;
        if (path.indexOf("..") == -1) {
            return path;
        }
        Stack<String> stack = new Stack<String>();
        for (String part : parts = path.split(File.separator)) {
            if (part.equals("..") && !stack.isEmpty()) {
                stack.pop();
                continue;
            }
            stack.push(part);
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = stack.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(File.separator);
        }
        return sb.toString();
    }

    private static synchronized File getDefaultTempDir() {
        if (defaultTempDir != null && defaultTempDir.exists()) {
            return defaultTempDir;
        }
        String s = System.getProperty("java.io.tmpdir");
        File checkExists = new File(s);
        if (!checkExists.exists()) {
            throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " does not exist, please set java.io.tempdir" + " to an existing directory");
        }
        Random ran = new Random();
        int x = ran.nextInt(1000000);
        File f = new File(s, "camel-tmp-" + x);
        while (!f.mkdir()) {
            x = ran.nextInt(1000000);
            f = new File(s, "camel-tmp-" + x);
        }
        defaultTempDir = f;
        Thread hook = new Thread(){

            public void run() {
                FileUtil.removeDir(defaultTempDir);
            }
        };
        Runtime.getRuntime().addShutdownHook(hook);
        return defaultTempDir;
    }
}

